/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class FoodValuesTooltip {
    private static final MutableComponent DELIMITER = new TextComponent(", ").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"white")));

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        FoodValues foodValues = FoodValuesDefinition.getFoodValues(event.getItemStack().m_41720_(), Minecraft.m_91087_().f_91073_.m_7465_());
        if (!foodValues.isEmpty()) {
            MutableComponent tooltip = null;
            for (Pair<FoodCategory, Float> entry : foodValues.entrySet()) {
                MutableComponent foodValuesText = new TextComponent(I18n.m_118938_((String)("item.crockpot.food_category_" + ((FoodCategory)((Object)entry.getKey())).name().toLowerCase()), (Object[])new Object[0]) + ": " + entry.getValue()).m_6270_(Style.f_131099_.m_131148_(((FoodCategory)((Object)entry.getKey())).color));
                if (tooltip == null) {
                    tooltip = foodValuesText;
                    continue;
                }
                tooltip.m_7220_((Component)DELIMITER).m_7220_((Component)foodValuesText);
            }
            event.getToolTip().add(tooltip);
        }
    }
}

