/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GnawsGiftHungerOverlay {
    private static final ResourceLocation GNAWS_GIFT_ICONS = new ResourceLocation("crockpot", "textures/gui/gnaws_gift.png");
    private static final Random RAND = new Random();
    private static int hungerBarOffset;

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (String)"CrockPot Get Hunger Bar Offset", (gui, mStack, partialTicks, width, height) -> {
                if (!((Boolean)CrockPotConfig.GNAWS_GIFT_HUNGER_OVERLAY.get()).booleanValue()) {
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                LocalPlayer player = mc.f_91074_;
                if (player != null && player.m_21023_(CrockPotRegistry.gnawsGift)) {
                    hungerBarOffset = gui.right_height;
                }
            });
            OverlayRegistry.registerOverlayAbove((IIngameOverlay)ForgeIngameGui.FOOD_LEVEL_ELEMENT, (String)"CrockPot Gnaw's Gift Hunger Overlay", (gui, mStack, partialTicks, width, height) -> {
                boolean isMounted;
                if (!((Boolean)CrockPotConfig.GNAWS_GIFT_HUNGER_OVERLAY.get()).booleanValue()) {
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                LocalPlayer player = mc.f_91074_;
                if (player != null && player.m_21023_(CrockPotRegistry.gnawsGift) && !(isMounted = player.m_20202_() instanceof LivingEntity) && !mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
                    mStack.m_85836_();
                    mStack.m_85837_(0.0, 0.0, 0.01);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GNAWS_GIFT_ICONS);
                    int left = mc.m_91268_().m_85445_() / 2 + 91;
                    int top = mc.m_91268_().m_85446_() - hungerBarOffset;
                    int tickCount = mc.f_91065_.m_93079_();
                    RAND.setSeed((long)tickCount * 312871L);
                    FoodData stats = player.m_36324_();
                    int level = stats.m_38702_();
                    for (int i = 0; i < 10; ++i) {
                        int idx = i * 2 + 1;
                        int x = left - i * 8 - 9;
                        int y = top;
                        if (stats.m_38722_() <= 0.0f && tickCount % (level * 3 + 1) == 0) {
                            y = top + (RAND.nextInt(3) - 1);
                        }
                        mc.f_91065_.m_93228_(mStack, x, y, 0, 0, 9, 9);
                        if (idx < level) {
                            mc.f_91065_.m_93228_(mStack, x, y, 9, 0, 9, 9);
                            continue;
                        }
                        if (idx != level) continue;
                        mc.f_91065_.m_93228_(mStack, x, y, 18, 0, 9, 9);
                    }
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
                    mStack.m_85849_();
                }
            });
        });
    }
}

