/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.event;

import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crockpot")
public class ExplosionCraftingEvent {
    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getWorld();
        if (!event.getWorld().f_46443_) {
            List affectedBlocks = event.getAffectedBlocks();
            List affectedEntities = event.getAffectedEntities();
            affectedBlocks.forEach(affectedBlock -> {
                BlockState blockState = level.m_8055_(affectedBlock);
                ExplosionCraftingRecipe recipe = ExplosionCraftingRecipe.getRecipeFor(blockState, level.m_7465_());
                if (recipe != null) {
                    blockState.onBlockExploded(level, affectedBlock, event.getExplosion());
                    ExplosionCraftingEvent.spawnAsInvulnerableEntity(level, affectedBlock, recipe.assemble(level.f_46441_));
                }
            });
            affectedEntities.forEach(affectedEntity -> {
                if (affectedEntity instanceof ItemEntity) {
                    ExplosionCraftingRecipe recipe;
                    ItemEntity itemEntity = (ItemEntity)affectedEntity;
                    if (affectedEntity.m_6084_() && (recipe = ExplosionCraftingRecipe.getRecipeFor(itemEntity.m_32055_(), level.m_7465_())) != null) {
                        while (!itemEntity.m_32055_().m_41619_()) {
                            ExplosionCraftingEvent.shrinkItemEntity(itemEntity, 1);
                            ExplosionCraftingEvent.spawnAsInvulnerableEntity(level, itemEntity.m_142538_(), recipe.assemble(level.f_46441_));
                        }
                    }
                }
            });
        }
    }

    private static void spawnAsInvulnerableEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !stack.m_41619_()) {
            double x = (double)pos.m_123341_() + Mth.m_14064_((Random)level.f_46441_, (double)0.25, (double)0.75);
            double y = (double)pos.m_123342_() + Mth.m_14064_((Random)level.f_46441_, (double)0.25, (double)0.75);
            double z = (double)pos.m_123343_() + Mth.m_14064_((Random)level.f_46441_, (double)0.25, (double)0.75);
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack);
            itemEntity.m_32060_();
            itemEntity.m_20331_(true);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private static void shrinkItemEntity(ItemEntity itemEntity, int count) {
        itemEntity.m_32062_();
        ItemStack itemStack = itemEntity.m_32055_().m_41777_();
        itemStack.m_41774_(count);
        itemEntity.m_32045_(itemStack);
        itemEntity.m_32060_();
    }
}

