/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jade;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.integration.jade.ModIntegrationJade;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.ArrayList;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CrockPotProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final CrockPotProvider INSTANCE = new CrockPotProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag serverData;
        if (config.get(ModIntegrationJade.CROCK_POT) && (serverData = accessor.getServerData()).m_128441_("CrockPotItemHandler")) {
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.deserializeNBT(serverData.m_128469_("CrockPotItemHandler"));
            IElementHelper helper = tooltip.getElementHelper();
            boolean needDrawInputs = false;
            for (int i = 0; i < 4; ++i) {
                if (itemHandler.getStackInSlot(i).m_41619_()) continue;
                needDrawInputs = true;
                break;
            }
            if (needDrawInputs) {
                ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>();
                ArrayList<IElement> inputs = new ArrayList<IElement>();
                for (int i = 0; i < 4; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    inputStacks.add(stackInSlot);
                    inputs.add(helper.item(stackInSlot));
                }
                tooltip.add(inputs);
                if (serverData.m_128471_("DrawFoodValue")) {
                    FoodValues mergedFoodValues = FoodValues.merge(inputStacks.stream().filter(stack -> !stack.m_41619_()).map(stack -> FoodValuesDefinition.getFoodValues(stack.m_41720_(), accessor.getLevel().m_7465_())).collect(Collectors.toList()));
                    int categoryCount = 0;
                    for (Pair<FoodCategory, Float> entry : mergedFoodValues.entrySet()) {
                        if (categoryCount % 3 == 0) {
                            tooltip.add(helper.item(FoodCategory.getItemStack((FoodCategory)((Object)entry.getKey()))));
                        } else {
                            tooltip.append(helper.spacer(2, 0));
                            tooltip.append(helper.item(FoodCategory.getItemStack((FoodCategory)((Object)entry.getKey()))));
                        }
                        tooltip.append(helper.text((Component)new TextComponent("\u00d7" + entry.getValue())));
                        ++categoryCount;
                    }
                }
            }
            if (serverData.m_128441_("Result")) {
                ItemStack result = ItemStack.m_41712_((CompoundTag)serverData.m_128469_("Result"));
                tooltip.add(helper.text((Component)new TranslatableComponent("integration.crockpot.top.recipe")));
                tooltip.append(helper.item(result));
                tooltip.append(helper.text(result.m_41786_()));
            }
            if (serverData.m_128441_("CookingProgress")) {
                float progress = serverData.m_128457_("CookingProgress");
                tooltip.add(helper.progress(progress, null, helper.progressStyle(), helper.borderStyle()));
            }
        }
    }

    public void appendServerData(CompoundTag tag, ServerPlayer player, Level level, BlockEntity blockEntity, boolean showDetails) {
        if (blockEntity instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotTileEntity = (CrockPotBlockEntity)blockEntity;
            tag.m_128473_("jadeHandler");
            tag.m_128365_("CrockPotItemHandler", (Tag)crockPotTileEntity.getItemHandler().serializeNBT());
            tag.m_128379_("DrawFoodValue", player.m_6144_());
            if (crockPotTileEntity.isCooking()) {
                tag.m_128365_("Result", (Tag)crockPotTileEntity.getResult().serializeNBT());
                tag.m_128350_("CookingProgress", crockPotTileEntity.getCookingProgress());
            }
        }
    }
}

