/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.AbstractDrawableRequirement;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CrockPotCookingRecipeCategory
implements IRecipeCategory<CrockPotCookingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "crock_pot_cooking");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable priority;
    private final IDrawable time;
    private final LoadingCache<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>> cachedDrawables;
    public static final List<ItemStack> POTS = ImmutableList.of((Object)CrockPotRegistry.crockPotBasicBlockItem.m_7968_(), (Object)CrockPotRegistry.crockPotAdvancedBlockItem.m_7968_(), (Object)CrockPotRegistry.crockPotUltimateBlockItem.m_7968_());

    public CrockPotCookingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 0, 0, 176, 133);
        this.icon = guiHelper.createDrawableIngredient((Object)CrockPotRegistry.crockPotBasicBlockItem.m_7968_());
        this.priority = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 176, 0, 16, 16);
        this.time = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/crock_pot_cooking.png"), 176, 16, 16, 16);
        this.cachedDrawables = CacheBuilder.newBuilder().maximumSize(32L).build((CacheLoader)new CacheLoader<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>>(){

            public List<AbstractDrawableRequirement<? extends IRequirement>> load(CrockPotCookingRecipe key) {
                return AbstractDrawableRequirement.getDrawables(key.getRequirements());
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrockPotCookingRecipe> getRecipeClass() {
        return CrockPotCookingRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("integration.crockpot.jei.crock_pot_cooking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CrockPotCookingRecipe recipe, IIngredients ingredients) {
        ArrayList inputLists = new ArrayList();
        ArrayList<ItemStack> pots = new ArrayList<ItemStack>();
        for (int i = 0; i < POTS.size(); ++i) {
            if (i < recipe.getPotLevel()) continue;
            pots.add(POTS.get(i));
        }
        inputLists.add(pots);
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        drawables.forEach(drawable -> inputLists.addAll(drawable.getInputLists()));
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrockPotCookingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int slot = 0;
        guiItemStacks.init(slot, true, 61, 103);
        guiItemStacks.set(slot++, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.init(slot, false, 103, 109);
        guiItemStacks.set(slot++, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            List<AbstractDrawableRequirement.GuiItemStacksInfo> guiItemStacksInfos = drawable.getGuiItemStacksInfos(xOffset, yOffset);
            for (AbstractDrawableRequirement.GuiItemStacksInfo guiItemStacksInfo : guiItemStacksInfos) {
                guiItemStacks.init(slot, true, guiItemStacksInfo.x - 1, guiItemStacksInfo.y - 1);
                guiItemStacks.set(slot++, guiItemStacksInfo.stacks);
            }
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
    }

    public void draw(CrockPotCookingRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int cookingTime = recipe.getCookingTime();
        if (cookingTime > 0) {
            int cookingTimeSeconds = cookingTime / 20;
            this.time.draw(stack, 0, 117);
            font.m_92889_(stack, (Component)new TranslatableComponent("integration.crockpot.jei.crock_pot_cooking.cooking_time.second", new Object[]{cookingTimeSeconds}), 17.0f, 121.0f, -8355712);
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = font.m_92895_(priorityString);
        this.priority.draw(stack, 159 - priorityWidth, 117);
        font.m_92883_(stack, priorityString, (float)(175 - priorityWidth), 121.0f, -8355712);
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            drawable.draw(stack, xOffset, yOffset);
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
    }

    public List<Component> getTooltipStrings(CrockPotCookingRecipe recipe, double mouseX, double mouseY) {
        if (mouseX >= 0.0 && mouseX <= 16.0 && mouseY >= 117.0 && mouseY <= 133.0) {
            return Collections.singletonList(new TranslatableComponent("integration.crockpot.jei.crock_pot_cooking.cooking_time"));
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = Minecraft.m_91087_().f_91062_.m_92895_(priorityString);
        if (mouseX >= 159.0 - (double)priorityWidth && mouseX <= 175.0 - (double)priorityWidth && mouseY >= 117.0 && mouseY <= 133.0) {
            return Collections.singletonList(new TranslatableComponent("integration.crockpot.jei.crock_pot_cooking.priority"));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

