/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sihenzhang.crockpot.integration.jei.gui.DrawableFramed;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ExplosionCraftingRecipeCategory
implements IRecipeCategory<ExplosionCraftingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "explosion_crafting");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated animatedExplosion;
    private final IDrawable onlyBlock;

    public ExplosionCraftingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 0, 0, 127, 46);
        this.icon = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/icons.png"), 0, 0, 16, 16);
        this.animatedExplosion = new DrawableFramed(guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 127, 0, 27, 240), 20, 10, IDrawableAnimated.StartDirection.TOP);
        this.onlyBlock = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/explosion_crafting.png"), 154, 0, 16, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ExplosionCraftingRecipe> getRecipeClass() {
        return ExplosionCraftingRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("integration.crockpot.jei.explosion_crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(IRecipeLayout recipeLayout, ExplosionCraftingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 18, 9);
        guiItemStacks.init(1, false, 87, 9);
        guiItemStacks.set(ingredients);
    }

    public void draw(ExplosionCraftingRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        this.animatedExplosion.draw(stack, 46, 6);
        if (recipe.isOnlyBlock()) {
            this.onlyBlock.draw(stack, 21, 29);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        String chance = MathUtils.format(1.0f - recipe.getLossRate(), "0.##%");
        int width = font.m_92895_(chance);
        font.m_92883_(stack, chance, 97.0f - (float)width / 2.0f, 36.0f, -8355712);
    }

    public List<Component> getTooltipStrings(ExplosionCraftingRecipe recipe, double mouseX, double mouseY) {
        if (recipe.isOnlyBlock() && mouseX >= 21.0 && mouseX <= 37.0 && mouseY >= 29.0 && mouseY <= 45.0) {
            return Collections.singletonList(new TranslatableComponent("integration.crockpot.jei.explosion_crafting.only_block"));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

