/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.sihenzhang.crockpot.integration.jei.JeiUtils;
import com.sihenzhang.crockpot.recipe.RangedItem;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import com.sihenzhang.crockpot.util.MathUtils;
import com.sihenzhang.crockpot.util.NbtUtils;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class PiglinBarteringRecipeCategory
implements IRecipeCategory<PiglinBarteringRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "piglin_bartering");
    private final IDrawable background;
    private final IDrawable icon;
    private final Cache<PiglinBarteringRecipe, IGuiIngredient<ItemStack>> cachedInputGuiIngredients;

    public PiglinBarteringRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/piglin_bartering.png"), 0, 0, 176, 112);
        this.icon = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/icons.png"), 32, 0, 16, 16);
        this.cachedInputGuiIngredients = CacheBuilder.newBuilder().maximumSize(16L).build();
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends PiglinBarteringRecipe> getRecipeClass() {
        return PiglinBarteringRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("integration.crockpot.jei.piglin_bartering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PiglinBarteringRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getWeightedResults().m_146338_().stream().map(e -> NbtUtils.setLoreString(((RangedItem)e.m_146310_()).item.m_7968_(), PiglinBarteringRecipeCategory.getCountAndChanceString((WeightedEntry.Wrapper<RangedItem>)e, recipe.getWeightedResults().f_146324_))).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, PiglinBarteringRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int slot = 0;
        guiItemStacks.init(slot++, true, 31, 2);
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 5; ++col) {
                guiItemStacks.init(slot++, false, 84 + col * 18, 2 + row * 18);
            }
        }
        List<List<ItemStack>> pagedIngredientsOutputs = JeiUtils.getPagedIngredients(recipeLayout, ingredients, 30, false);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        for (int i = 0; i < pagedIngredientsOutputs.size(); ++i) {
            guiItemStacks.set(i + 1, pagedIngredientsOutputs.get(i));
        }
        this.cachedInputGuiIngredients.put((Object)recipe, (Object)((IGuiIngredient)guiItemStacks.getGuiIngredients().get(0)));
    }

    public void draw(PiglinBarteringRecipe recipe, PoseStack stack, double mouseX, double mouseY) {
        boolean emptyInOffhand;
        ItemStack inputStack;
        Piglin piglin = (Piglin)EntityType.f_20511_.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        piglin.m_34670_(true);
        piglin.m_8061_(EquipmentSlot.MAINHAND, Items.f_42430_.m_7968_());
        IGuiIngredient inputGuiIngredient = (IGuiIngredient)this.cachedInputGuiIngredients.getIfPresent((Object)recipe);
        if (inputGuiIngredient != null && (inputStack = (ItemStack)inputGuiIngredient.getDisplayedIngredient()) != null) {
            piglin.m_8061_(EquipmentSlot.OFFHAND, inputStack);
            piglin.m_6274_().m_21879_(MemoryModuleType.f_26336_, (Object)true);
        }
        if (emptyInOffhand = piglin.m_21206_().m_41619_()) {
            double yaw = 30.0 - mouseX;
            double pitch = 45.0 - mouseY;
            piglin.f_20883_ = (float)Math.atan(yaw / 40.0) * 20.0f;
            piglin.m_146922_((float)Math.atan(yaw / 40.0) * 40.0f);
            piglin.m_146926_(-((float)Math.atan(pitch / 40.0)) * 20.0f);
            piglin.f_20885_ = piglin.m_146908_();
            piglin.f_20886_ = piglin.m_146908_();
        }
        stack.m_85836_();
        stack.m_85837_(emptyInOffhand ? 29.0 : 37.0, 103.0, 50.0);
        stack.m_85841_(-32.0f, 32.0f, 32.0f);
        stack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        if (!emptyInOffhand) {
            stack.m_85845_(Vector3f.f_122224_.m_122240_(45.0f));
        }
        EntityRenderDispatcher entityRendererDispatcher = Minecraft.m_91087_().m_91290_();
        MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRendererDispatcher.m_114468_(false);
        entityRendererDispatcher.m_114384_((Entity)piglin, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (MultiBufferSource)multiBufferSource, 0xF000F0);
        entityRendererDispatcher.m_114468_(true);
        multiBufferSource.m_109911_();
        stack.m_85849_();
    }

    private static String getCountAndChanceString(WeightedEntry.Wrapper<RangedItem> weightedRangedItem, int totalWeight) {
        RangedItem rangedItem = (RangedItem)weightedRangedItem.m_146310_();
        float chance = (float)weightedRangedItem.m_142631_().m_146281_() / (float)totalWeight;
        StringBuilder chanceTooltip = new StringBuilder();
        if (rangedItem.isRanged()) {
            chanceTooltip.append(rangedItem.min).append("-").append(rangedItem.max);
        } else {
            chanceTooltip.append(rangedItem.min);
        }
        chanceTooltip.append(" (").append(MathUtils.format(chance, "0.00%")).append(")");
        return chanceTooltip.toString();
    }
}

