/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei.gui.requirement;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sihenzhang.crockpot.integration.jei.gui.DrawableNineSliceResource;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMax;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMin;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCombinationAnd;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementCombinationOr;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementMustContainIngredient;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.DrawableRequirementMustContainIngredientLessThan;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMax;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMaxExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMin;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCategoryMinExclusive;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationAnd;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementCombinationOr;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredient;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementMustContainIngredientLessThan;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractDrawableRequirement<T extends IRequirement>
implements IDrawable {
    protected final T requirement;
    protected final Component description;

    public AbstractDrawableRequirement(T requirement, Component description) {
        this.requirement = requirement;
        this.description = description;
    }

    public void draw(PoseStack stack, int xOffset, int yOffset) {
        this.drawRequirementBackground(stack, xOffset, yOffset);
    }

    private void drawRequirementBackground(PoseStack stack, int xOffset, int yOffset) {
        DrawableNineSliceResource drawable = new DrawableNineSliceResource(new ResourceLocation("crockpot", "textures/gui/jei/requirement_background.png"), 0, 0, 64, 64, this.getWidth(), this.getHeight(), 8, 8, 8, 8, 64, 64);
        drawable.draw(stack, xOffset, yOffset);
    }

    public abstract List<GuiItemStacksInfo> getGuiItemStacksInfos(int var1, int var2);

    public abstract List<List<ItemStack>> getInputLists();

    public static AbstractDrawableRequirement<? extends IRequirement> createDrawable(IRequirement requirement) {
        if (requirement instanceof RequirementCategoryMax) {
            return new DrawableRequirementCategoryMax((RequirementCategoryMax)requirement);
        }
        if (requirement instanceof RequirementCategoryMaxExclusive) {
            return new DrawableRequirementCategoryMaxExclusive((RequirementCategoryMaxExclusive)requirement);
        }
        if (requirement instanceof RequirementCategoryMin) {
            return new DrawableRequirementCategoryMin((RequirementCategoryMin)requirement);
        }
        if (requirement instanceof RequirementCategoryMinExclusive) {
            return new DrawableRequirementCategoryMinExclusive((RequirementCategoryMinExclusive)requirement);
        }
        if (requirement instanceof RequirementCombinationAnd) {
            return new DrawableRequirementCombinationAnd((RequirementCombinationAnd)requirement);
        }
        if (requirement instanceof RequirementCombinationOr) {
            return new DrawableRequirementCombinationOr((RequirementCombinationOr)requirement);
        }
        if (requirement instanceof RequirementMustContainIngredient) {
            return new DrawableRequirementMustContainIngredient((RequirementMustContainIngredient)requirement);
        }
        if (requirement instanceof RequirementMustContainIngredientLessThan) {
            return new DrawableRequirementMustContainIngredientLessThan((RequirementMustContainIngredientLessThan)requirement);
        }
        throw new IllegalArgumentException("No valid requirement was found");
    }

    public static List<AbstractDrawableRequirement<? extends IRequirement>> getDrawables(List<IRequirement> requirements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (requirements.isEmpty()) {
            builder.add((Object)new AbstractDrawableRequirement<IRequirement>(null, (Component)new TranslatableComponent("integration.crockpot.jei.crock_pot_cooking.requirement.no_requirement")){

                public int getWidth() {
                    return 6 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.description);
                }

                public int getHeight() {
                    return 14;
                }

                @Override
                public void draw(PoseStack stack, int xOffset, int yOffset) {
                    super.draw(stack, xOffset, yOffset);
                    Minecraft.m_91087_().f_91062_.m_92889_(stack, this.description, (float)(xOffset + 3), (float)(yOffset + 3), 0);
                }

                @Override
                public List<List<ItemStack>> getInputLists() {
                    return ImmutableList.of();
                }

                @Override
                public List<GuiItemStacksInfo> getGuiItemStacksInfos(int xOffset, int yOffset) {
                    return ImmutableList.of();
                }
            });
        } else {
            ArrayList<IRequirement> tmpRequirements = new ArrayList<IRequirement>(requirements);
            Iterator it = tmpRequirements.iterator();
            while (it.hasNext()) {
                IRequirement requirement = (IRequirement)it.next();
                if (requirement instanceof RequirementMustContainIngredient || requirement instanceof RequirementMustContainIngredientLessThan) {
                    Optional<RequirementMustContainIngredientLessThan> requirementMustContainIngredientLessThan;
                    if (requirement instanceof RequirementMustContainIngredient) {
                        RequirementMustContainIngredient requirementMustContainIngredient = (RequirementMustContainIngredient)requirement;
                        requirementMustContainIngredientLessThan = tmpRequirements.stream().filter(r -> r instanceof RequirementMustContainIngredientLessThan).map(RequirementMustContainIngredientLessThan.class::cast).filter(r -> {
                            if (requirementMustContainIngredient.getQuantity() != r.getQuantity()) {
                                return false;
                            }
                            IntList first = requirementMustContainIngredient.getIngredient().m_43931_();
                            IntList second = r.getIngredient().m_43931_();
                            return first.size() == second.size() && first.containsAll((IntCollection)second) && second.containsAll((IntCollection)first);
                        }).findFirst();
                        if (requirementMustContainIngredientLessThan.isPresent()) {
                            builder.add((Object)new DrawableRequirementMustContainIngredient(requirementMustContainIngredient, (RequirementMustContainIngredientLessThan)requirementMustContainIngredientLessThan.get()));
                            continue;
                        }
                        builder.add(AbstractDrawableRequirement.createDrawable(requirement));
                        continue;
                    }
                    requirementMustContainIngredientLessThan = (RequirementMustContainIngredientLessThan)requirement;
                    Optional<RequirementMustContainIngredient> requirementMustContainIngredient = tmpRequirements.stream().filter(r -> r instanceof RequirementMustContainIngredient).map(RequirementMustContainIngredient.class::cast).filter(arg_0 -> AbstractDrawableRequirement.lambda$getDrawables$3((RequirementMustContainIngredientLessThan)((Object)requirementMustContainIngredientLessThan), arg_0)).findFirst();
                    if (requirementMustContainIngredient.isPresent()) {
                        it.remove();
                        continue;
                    }
                    builder.add(AbstractDrawableRequirement.createDrawable(requirement));
                    continue;
                }
                builder.add(AbstractDrawableRequirement.createDrawable(requirement));
            }
        }
        return builder.build();
    }

    private static /* synthetic */ boolean lambda$getDrawables$3(RequirementMustContainIngredientLessThan requirementMustContainIngredientLessThan, RequirementMustContainIngredient r) {
        if (requirementMustContainIngredientLessThan.getQuantity() != r.getQuantity()) {
            return false;
        }
        IntList first = requirementMustContainIngredientLessThan.getIngredient().m_43931_();
        IntList second = r.getIngredient().m_43931_();
        return first.size() == second.size() && first.containsAll((IntCollection)second) && second.containsAll((IntCollection)first);
    }

    public static class GuiItemStacksInfo {
        public List<ItemStack> stacks;
        public int x;
        public int y;

        public GuiItemStacksInfo(List<ItemStack> stacks, int x, int y) {
            this.stacks = stacks;
            this.x = x;
            this.y = y;
        }
    }
}

