/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class CrockPotFood
extends Item {
    private final int duration;
    private final boolean isDrink;
    private final int cooldown;
    private final float heal;
    private final Pair<DamageSource, Float> damage;
    private final List<MobEffect> removedEffects;
    private final List<Supplier<Component>> tooltips;

    protected CrockPotFood(CrockPotFoodBuilder builder) {
        super(builder.properties.m_41489_(builder.foodBuilder.m_38767_()));
        this.duration = builder.duration;
        this.isDrink = builder.isDrink;
        this.cooldown = builder.cooldown;
        this.heal = builder.heal;
        this.damage = builder.damage;
        this.removedEffects = builder.removedEffects;
        this.tooltips = builder.tooltips;
    }

    public static CrockPotFoodBuilder builder() {
        return new CrockPotFoodBuilder();
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (!level.f_46443_) {
            if (this.damage != null && ((Float)this.damage.getValue()).floatValue() > 1.0E-6f) {
                livingEntity.m_6469_((DamageSource)this.damage.getKey(), ((Float)this.damage.getValue()).floatValue());
            }
            if (this.heal > 1.0E-6f) {
                livingEntity.m_5634_(this.heal);
            }
            this.removedEffects.forEach(arg_0 -> ((LivingEntity)livingEntity).m_21195_(arg_0));
            if (this.cooldown > 0 && livingEntity instanceof Player) {
                ((Player)livingEntity).m_36335_().m_41524_((Item)this, this.cooldown);
            }
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    public int m_8105_(ItemStack stack) {
        return this.duration;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.isDrink) {
            return UseAnim.DRINK;
        }
        return super.m_6164_(stack);
    }

    public SoundEvent m_6061_() {
        if (this.isDrink) {
            return SoundEvents.f_11911_;
        }
        return super.m_6061_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (!this.tooltips.isEmpty()) {
            this.tooltips.forEach(tip -> tooltipComponents.add((Component)tip.get()));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static class CrockPotFoodBuilder {
        private Item.Properties properties = new Item.Properties().m_41491_(CrockPot.ITEM_GROUP);
        private int maxStackSize = 64;
        private Rarity rarity = Rarity.COMMON;
        private FoodProperties.Builder foodBuilder = new FoodProperties.Builder();
        private int duration;
        private boolean isDrink;
        private int cooldown;
        private float heal;
        private Pair<DamageSource, Float> damage;
        private final List<MobEffect> removedEffects;
        private final List<Supplier<Component>> tooltips;

        public CrockPotFoodBuilder() {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<MobEffect>();
            this.tooltips = new ArrayList<Supplier<Component>>();
        }

        public CrockPotFoodBuilder nutrition(int nutrition) {
            this.foodBuilder = this.foodBuilder.m_38760_(nutrition);
            return this;
        }

        public CrockPotFoodBuilder saturationMod(float saturationModifier) {
            this.foodBuilder = this.foodBuilder.m_38758_(saturationModifier);
            return this;
        }

        public CrockPotFoodBuilder meat() {
            this.foodBuilder = this.foodBuilder.m_38757_();
            return this;
        }

        public CrockPotFoodBuilder alwaysEat() {
            this.foodBuilder = this.foodBuilder.m_38765_();
            return this;
        }

        public CrockPotFoodBuilder duration(FoodUseDuration duration) {
            this.duration = duration.val;
            return this;
        }

        public CrockPotFoodBuilder effect(Supplier<MobEffectInstance> effect, float probability) {
            this.foodBuilder = this.foodBuilder.effect(effect, probability);
            return this;
        }

        public CrockPotFoodBuilder effect(Supplier<MobEffectInstance> effect) {
            this.foodBuilder = this.foodBuilder.effect(effect, 1.0f);
            return this;
        }

        public CrockPotFoodBuilder effect(MobEffect effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration, amplifier), probability);
        }

        public CrockPotFoodBuilder effect(MobEffect effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public CrockPotFoodBuilder effect(MobEffect effect, int duration, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration), probability);
        }

        public CrockPotFoodBuilder effect(MobEffect effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public CrockPotFoodBuilder drink() {
            this.isDrink = true;
            return this;
        }

        public CrockPotFoodBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public CrockPotFoodBuilder heal(float heal) {
            this.heal = heal;
            return this;
        }

        public CrockPotFoodBuilder damage(DamageSource damageSource, float damageAmount) {
            this.damage = Pair.of((Object)damageSource, (Object)Float.valueOf(damageAmount));
            return this;
        }

        public CrockPotFoodBuilder removeEffect(MobEffect effect) {
            this.removedEffects.add(effect);
            return this;
        }

        public CrockPotFoodBuilder tooltip(String key) {
            this.tooltips.add(() -> new TranslatableComponent("tooltip.crockpot." + key));
            return this;
        }

        public CrockPotFoodBuilder tooltip(String key, ChatFormatting ... formats) {
            this.tooltips.add(() -> new TranslatableComponent("tooltip.crockpot." + key).m_130944_(formats));
            return this;
        }

        public CrockPotFoodBuilder hide() {
            this.properties = new Item.Properties();
            if (this.maxStackSize != 64) {
                this.properties = this.properties.m_41487_(this.maxStackSize);
            }
            if (this.rarity != Rarity.COMMON) {
                this.properties = this.properties.m_41497_(this.rarity);
            }
            return this;
        }

        public CrockPotFoodBuilder stacksTo(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            this.properties = this.properties.m_41487_(this.maxStackSize);
            return this;
        }

        public CrockPotFoodBuilder rarity(Rarity rarity) {
            this.rarity = rarity;
            this.properties = this.properties.m_41497_(this.rarity);
            return this;
        }

        public CrockPotFood build() {
            return new CrockPotFood(this);
        }
    }
}

