/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CrockPotCropsFeatureConfig
implements FeatureConfiguration {
    public static final Codec<CrockPotCropsFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.fieldOf("state_provider").forGetter(config -> config.cropsBlock.m_49966_()), (App)BlockState.f_61039_.listOf().fieldOf("whitelist").orElse((Object)ImmutableSet.of((Object)Blocks.f_50440_.m_49966_()).asList()).forGetter(config -> config.whitelist.stream().map(Block::m_49966_).collect(Collectors.toList())), (App)BlockState.f_61039_.fieldOf("replacement_block").orElse((Object)Blocks.f_50093_.m_49966_()).forGetter(config -> config.replacementBlock.m_49966_()), (App)Codec.INT.fieldOf("tries").orElse((Object)32).forGetter(config -> config.tryCount), (App)Codec.INT.fieldOf("spread_radius").orElse((Object)2).forGetter(config -> config.spreadRadius)).apply((Applicative)instance, CrockPotCropsFeatureConfig::new));
    public final AbstractCrockPotCropBlock cropsBlock;
    public final Set<Block> whitelist;
    public final Block replacementBlock;
    public final int tryCount;
    public final int spreadRadius;

    private CrockPotCropsFeatureConfig(BlockState cropsBlock, List<BlockState> whitelist, BlockState replacedBlock, int tryCount, int spreadRadius) {
        this((AbstractCrockPotCropBlock)cropsBlock.m_60734_(), whitelist.stream().map(BlockBehaviour.BlockStateBase::m_60734_).collect(Collectors.toSet()), replacedBlock.m_60734_(), tryCount, spreadRadius);
    }

    private CrockPotCropsFeatureConfig(AbstractCrockPotCropBlock cropsBlock, Set<Block> whitelist, Block replacementBlock, int tryCount, int spreadRadius) {
        this.cropsBlock = cropsBlock;
        this.whitelist = whitelist;
        this.replacementBlock = replacementBlock;
        this.tryCount = tryCount;
        this.spreadRadius = spreadRadius;
    }

    public static CrockPotCropsFeatureConfigBuilder builder(AbstractCrockPotCropBlock cropsBlock) {
        return new CrockPotCropsFeatureConfigBuilder(cropsBlock);
    }

    public static class CrockPotCropsFeatureConfigBuilder {
        private final AbstractCrockPotCropBlock cropsBlock;
        private Set<Block> whitelist = ImmutableSet.of((Object)Blocks.f_50440_);
        private Block replacementBlock = Blocks.f_50093_;
        private int tryCount = 64;
        private int spreadRadius = 2;

        public CrockPotCropsFeatureConfigBuilder(AbstractCrockPotCropBlock cropsBlock) {
            this.cropsBlock = cropsBlock;
        }

        public CrockPotCropsFeatureConfigBuilder whitelist(Set<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder replacedBy(Block replacementBlock) {
            this.replacementBlock = replacementBlock;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder tries(int tryCount) {
            this.tryCount = tryCount;
            return this;
        }

        public CrockPotCropsFeatureConfigBuilder spreadRadius(int spreadRadius) {
            this.spreadRadius = spreadRadius;
            return this;
        }

        public CrockPotCropsFeatureConfig build() {
            return new CrockPotCropsFeatureConfig(this.cropsBlock, this.whitelist, this.replacementBlock, this.tryCount, this.spreadRadius);
        }
    }
}

