/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.bartering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.recipe.RangedItem;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PiglinBarteringRecipe
extends AbstractCrockPotRecipe {
    private final Ingredient ingredient;
    private final SimpleWeightedRandomList<RangedItem> weightedResults;

    public PiglinBarteringRecipe(ResourceLocation id, Ingredient ingredient, SimpleWeightedRandomList<RangedItem> weightedResults) {
        super(id);
        this.ingredient = ingredient;
        this.weightedResults = weightedResults;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public SimpleWeightedRandomList<RangedItem> getWeightedResults() {
        return this.weightedResults;
    }

    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nullable
    public static PiglinBarteringRecipe getRecipeFor(ItemStack stack, RecipeManager recipeManager) {
        return stack.m_41619_() ? null : (PiglinBarteringRecipe)recipeManager.m_44013_(CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE).stream().filter(r -> r.matches(stack)).findFirst().orElse(null);
    }

    @Nullable
    public static PiglinBarteringRecipe getRecipeFor(Item item, RecipeManager recipeManager) {
        return item == null || item == Items.f_41852_ ? null : (PiglinBarteringRecipe)recipeManager.m_44013_(CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE).stream().filter(r -> r.matches(item.m_7968_())).findFirst().orElse(null);
    }

    public ItemStack assemble(Random rand) {
        Optional result = this.weightedResults.m_146266_(rand);
        if (result.isPresent()) {
            RangedItem rangedItem = (RangedItem)result.get();
            if (rangedItem.isRanged()) {
                return new ItemStack((ItemLike)rangedItem.item, Mth.m_14072_((Random)rand, (int)rangedItem.min, (int)rangedItem.max));
            }
            return new ItemStack((ItemLike)rangedItem.item, rangedItem.min);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return CrockPotRegistry.piglinBartering;
    }

    public RecipeType<?> m_6671_() {
        return CrockPotRecipeTypes.PIGLIN_BARTERING_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<PiglinBarteringRecipe> {
        public PiglinBarteringRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(serializedRecipe, "ingredient");
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            JsonArray results = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"results");
            results.forEach(result -> {
                RangedItem rangedItem = RangedItem.fromJson(result);
                if (rangedItem != null) {
                    int weight = GsonHelper.m_13824_((JsonObject)GsonHelper.m_13918_((JsonElement)result, (String)"weighted ranged item"), (String)"weight", (int)1);
                    builder.m_146271_((Object)rangedItem, weight);
                }
            });
            return new PiglinBarteringRecipe(recipeId, ingredient, (SimpleWeightedRandomList<RangedItem>)builder.m_146270_());
        }

        @Nullable
        public PiglinBarteringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            int length = buffer.m_130242_();
            for (int i = 0; i < length; ++i) {
                RangedItem rangedItem = RangedItem.fromNetwork(buffer);
                int weight = buffer.m_130242_();
                builder.m_146271_((Object)rangedItem, weight);
            }
            return new PiglinBarteringRecipe(recipeId, ingredient, (SimpleWeightedRandomList<RangedItem>)builder.m_146270_());
        }

        public void toNetwork(FriendlyByteBuf buffer, PiglinBarteringRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            List weightedRangedItems = recipe.getWeightedResults().m_146338_();
            buffer.m_130130_(weightedRangedItems.size());
            weightedRangedItems.forEach(weightedRangedItem -> {
                ((RangedItem)weightedRangedItem.m_146310_()).toNetwork(buffer);
                buffer.m_130130_(weightedRangedItem.m_142631_().m_146281_());
            });
        }
    }
}

