/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.capability;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.sihenzhang.crockpot.capability.IFoodCounter;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoodCounter
implements IFoodCounter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Multiset<Item> counter = HashMultiset.create();

    @Override
    public boolean hasEaten(Item food) {
        return this.counter.contains((Object)food);
    }

    @Override
    public void addFood(Item food) {
        this.counter.add((Object)food);
    }

    @Override
    public int getCount(Item food) {
        return this.counter.count((Object)food);
    }

    @Override
    public void setCount(Item food, int count) {
        this.counter.setCount((Object)food, count);
    }

    @Override
    public void clear() {
        this.counter.clear();
    }

    @Override
    public Map<Item, Integer> asMap() {
        return Maps.asMap((Set)this.counter.elementSet(), arg_0 -> this.counter.count(arg_0));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        this.asMap().forEach((food, count) -> {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)food);
            if (key != null) {
                CompoundTag foodCount = new CompoundTag();
                foodCount.m_128359_("Food", key.toString());
                foodCount.m_128405_("Count", count.intValue());
                list.add((Object)foodCount);
            }
        });
        tag.m_128365_("FoodCounter", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.clear();
        ListTag foodCounter = nbt.m_128437_("FoodCounter", 10);
        foodCounter.stream().map(CompoundTag.class::cast).forEach(foodCount -> {
            String key = foodCount.m_128461_("Food");
            Item food = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(foodCount.m_128461_("Food")));
            if (food == null) {
                LOGGER.warn("Attempt to load unregistered item: \"" + key + "\", will remove this.");
                return;
            }
            if (!food.m_41472_()) {
                LOGGER.warn("Attempting to load item that is not edible: \"" + key + "\", will not remove this in case it becomes edible again later.");
            }
            this.setCount(food, foodCount.m_128451_("Count"));
        });
    }
}

