/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.capability;

import com.sihenzhang.crockpot.base.CrockPotCriteriaTriggers;
import com.sihenzhang.crockpot.capability.FoodCounterProvider;
import com.sihenzhang.crockpot.capability.IFoodCounter;
import com.sihenzhang.crockpot.network.NetworkManager;
import com.sihenzhang.crockpot.network.PacketFoodCounter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crockpot")
public class FoodCounterCapabilityHandler {
    public static Capability<IFoodCounter> FOOD_COUNTER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFoodCounter>(){});
    public static final ResourceLocation FOOD_COUNTER = new ResourceLocation("crockpot", "food_counter");

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IFoodCounter.class);
    }

    @SubscribeEvent
    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(FOOD_COUNTER, (ICapabilityProvider)new FoodCounterProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerAppear(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FoodCounterCapabilityHandler.syncFoodCounter((Player)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getPlayer();
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        oldPlayer.getCapability(FOOD_COUNTER_CAPABILITY).ifPresent(oldFoodCounter -> player.getCapability(FOOD_COUNTER_CAPABILITY).ifPresent(newFoodCounter -> newFoodCounter.deserializeNBT((Tag)((CompoundTag)oldFoodCounter.serializeNBT()))));
    }

    @SubscribeEvent
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        ServerPlayer player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntityLiving();
                if (!(livingEntity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)livingEntity;
                if (event.getItem().m_41614_()) break block3;
            }
            return;
        }
        player.getCapability(FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> {
            ItemStack stack = event.getItem();
            foodCounter.addFood(stack.m_41720_());
            CrockPotCriteriaTriggers.EAT_FOOD_TRIGGER.trigger(player, stack, foodCounter.getCount(stack.m_41720_()));
        });
        FoodCounterCapabilityHandler.syncFoodCounter((Player)player);
    }

    public static void syncFoodCounter(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> NetworkManager.sendToPlayer(serverPlayer, new PacketFoodCounter((CompoundTag)foodCounter.serializeNBT())));
        }
    }
}

