/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crockpot")
public class FoodValuesTooltip {
    private static final MutableComponent DELIMITER = new TextComponent(", ").m_130940_(ChatFormatting.WHITE);

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        FoodValues foodValues;
        Player player = event.getPlayer();
        if (player != null && player.f_19853_ != null && !(foodValues = FoodValuesDefinition.getFoodValues(event.getItemStack().m_41720_(), player.f_19853_.m_7465_())).isEmpty()) {
            MutableComponent tooltip = null;
            for (Pair<FoodCategory, Float> entry : foodValues.entrySet()) {
                MutableComponent foodValuesText = new TranslatableComponent("tooltip.crockpot.food_values", new Object[]{new TranslatableComponent("item.crockpot.food_category_" + ((FoodCategory)((Object)entry.getKey())).name().toLowerCase()), entry.getValue()}).m_130948_(Style.f_131099_.m_131148_(((FoodCategory)((Object)entry.getKey())).color));
                if (tooltip == null) {
                    tooltip = foodValuesText;
                    continue;
                }
                tooltip.m_7220_((Component)DELIMITER).m_7220_((Component)foodValuesText);
            }
            event.getToolTip().add(tooltip);
        }
    }
}

