/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.integration.jei.JeiUtils;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FoodValuesCategory
implements IRecipeCategory<FoodValuesDefinition.FoodCategoryMatchedItems> {
    public static final ResourceLocation UID = new ResourceLocation("crockpot", "food_values");
    private final IDrawable background;
    private final IDrawable icon;

    public FoodValuesCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/food_values.png"), 0, 0, 166, 117);
        this.icon = guiHelper.createDrawable(new ResourceLocation("crockpot", "textures/gui/jei/icons.png"), 16, 0, 16, 16);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends FoodValuesDefinition.FoodCategoryMatchedItems> getRecipeClass() {
        return FoodValuesDefinition.FoodCategoryMatchedItems.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("integration.crockpot.jei.food_values");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FoodValuesDefinition.FoodCategoryMatchedItems recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, recipe.getItems().stream().map(Item::m_7968_).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)FoodCategory.getItemStack(recipe.getCategory()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, FoodValuesDefinition.FoodCategoryMatchedItems recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int slot = 0;
        for (int row = 0; row < 5; ++row) {
            for (int col = 0; col < 9; ++col) {
                guiItemStacks.init(slot++, true, 2 + col * 18, 25 + row * 18);
            }
        }
        guiItemStacks.init(slot, false, 74, 2);
        List<List<ItemStack>> pagedIngredientsInputs = JeiUtils.getPagedIngredients(recipeLayout, ingredients, 45, true);
        for (int i = 0; i < pagedIngredientsInputs.size(); ++i) {
            guiItemStacks.set(i, pagedIngredientsInputs.get(i));
        }
        guiItemStacks.set(slot, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

