/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.world.item.ItemStack;

public final class JeiUtils {
    public static List<List<ItemStack>> getPagedIngredients(IRecipeLayout recipeLayout, IIngredients ingredients, int size, boolean input) {
        List<Object> ingredientStacks = input ? ingredients.getInputs(VanillaTypes.ITEM) : ingredients.getOutputs(VanillaTypes.ITEM);
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null && (input && focus.getMode() == IFocus.Mode.INPUT || !input && focus.getMode() == IFocus.Mode.OUTPUT)) {
            ingredientStacks = ingredientStacks.stream().filter(list -> ItemStack.m_41746_((ItemStack)((ItemStack)list.get(0)), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
        }
        if (ingredientStacks.size() > size) {
            ArrayList pagedIngredients = new ArrayList();
            for (int i = 0; i < size; ++i) {
                pagedIngredients.add(new ArrayList((Collection)ingredientStacks.get(i)));
            }
            int pages = (int)Math.ceil((double)ingredientStacks.size() / (double)size);
            for (int i = 1; i < pages; ++i) {
                for (int j = 0; j < size; ++j) {
                    ((List)pagedIngredients.get(j)).add(i * size + j < ingredientStacks.size() ? (ItemStack)((List)ingredientStacks.get(i * size + j)).get(0) : null);
                }
            }
            ingredientStacks = pagedIngredients;
        }
        return ingredientStacks;
    }
}

