/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.integration.kubejs.AbstractCrockPotRecipeJS;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.GsonHelper;

public class CrockPotCookingRecipeJS
extends AbstractCrockPotRecipeJS {
    public List<IRequirement> requirements = new ArrayList<IRequirement>();

    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        if (args.size() >= 5) {
            this.priority(((Number)args.get(1)).intValue());
            this.weight(((Number)args.get(2)).intValue());
            this.cookingTime(((Number)args.get(3)).intValue());
            this.potLevel(((Number)args.get(4)).intValue());
        } else {
            this.priority(((Number)args.get(1)).intValue());
            this.cookingTime(((Number)args.get(2)).intValue());
            this.potLevel(((Number)args.get(3)).intValue());
        }
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        GsonHelper.m_13933_((JsonObject)this.json, (String)"requirements").forEach(this::requirement);
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
        }
        if (this.serializeInputs) {
            JsonArray arr = new JsonArray();
            this.requirements.forEach(requirement -> arr.add(requirement.toJson()));
            this.json.add("requirements", (JsonElement)arr);
        }
    }

    public CrockPotCookingRecipeJS requirement(Object requirement) {
        this.requirements.add(this.parseRequirement(requirement));
        return this;
    }

    public CrockPotCookingRecipeJS requirementCategoryMax(String category, float max) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "category_max");
        json.addProperty("category", category);
        json.addProperty("max", (Number)Float.valueOf(max));
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementCategoryMaxExclusive(String category, float max) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "category_max_exclusive");
        json.addProperty("category", category);
        json.addProperty("max", (Number)Float.valueOf(max));
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementCategoryMin(String category, float min) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "category_min");
        json.addProperty("category", category);
        json.addProperty("min", (Number)Float.valueOf(min));
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementCategoryMinExclusive(String category, float min) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "category_min_exclusive");
        json.addProperty("category", category);
        json.addProperty("min", (Number)Float.valueOf(min));
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementCombinationAnd(Object first, Object second) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "combination_and");
        IRequirement firstRequirement = this.parseRequirement(first);
        json.add("first", firstRequirement.toJson());
        IRequirement secondRequirement = this.parseRequirement(second);
        json.add("second", secondRequirement.toJson());
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementCombinationOr(Object first, Object second) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "combination_or");
        IRequirement firstRequirement = this.parseRequirement(first);
        json.add("first", firstRequirement.toJson());
        IRequirement secondRequirement = this.parseRequirement(second);
        json.add("second", secondRequirement.toJson());
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementMustContainIngredient(Object ingredient, int quantity) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "must_contain_ingredient");
        json.add("ingredient", this.parseIngredientItem(ingredient).toJson());
        json.addProperty("quantity", (Number)quantity);
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS requirementMustContainIngredientLessThan(Object ingredient, int quantity) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "must_contain_ingredient_less_than");
        json.add("ingredient", this.parseIngredientItem(ingredient).toJson());
        json.addProperty("quantity", (Number)quantity);
        return this.requirement(json);
    }

    public CrockPotCookingRecipeJS priority(int priority) {
        this.json.addProperty("priority", (Number)priority);
        return this;
    }

    public CrockPotCookingRecipeJS weight(int weight) {
        this.json.addProperty("weight", (Number)Math.max(weight, 1));
        return this;
    }

    public CrockPotCookingRecipeJS cookingTime(int cookingTime) {
        this.json.addProperty("cookingtime", (Number)cookingTime);
        return this;
    }

    public CrockPotCookingRecipeJS potLevel(int potLevel) {
        this.json.addProperty("potlevel", (Number)potLevel);
        return this;
    }
}

