/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.integration.patchouli.PacketCrockPotConfigFlag;
import com.sihenzhang.crockpot.network.NetworkManager;
import com.sihenzhang.crockpot.util.JsonUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber(modid="crockpot")
public class ModIntegrationPatchouli {
    public static final String MOD_ID = "patchouli";
    private static final Map<String, Boolean> FLAGS = new Object2BooleanOpenHashMap(8);

    @SubscribeEvent
    public static void addConfigFlag(ServerAboutToStartEvent event) {
        if (ModList.get().isLoaded(MOD_ID)) {
            ModIntegrationPatchouli.setConfigFlag("unknown_seeds", (Boolean)CrockPotConfig.ENABLE_UNKNOWN_SEEDS.get());
            ModIntegrationPatchouli.setConfigFlag("world_gen", (Boolean)CrockPotConfig.ENABLE_WORLD_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("asparagus_gen", (Boolean)CrockPotConfig.ASPARAGUS_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("corn_gen", (Boolean)CrockPotConfig.CORN_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("eggplant_gen", (Boolean)CrockPotConfig.EGGPLANT_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("onion_gen", (Boolean)CrockPotConfig.ONION_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("pepper_gen", (Boolean)CrockPotConfig.PEPPER_GENERATION.get());
            ModIntegrationPatchouli.setConfigFlag("tomato_gen", (Boolean)CrockPotConfig.TOMATO_GENERATION.get());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (ModList.get().isLoaded(MOD_ID)) {
                NetworkManager.sendToPlayer(player2, new PacketCrockPotConfigFlag(ModIntegrationPatchouli.getConfigFlags()));
            }
        }
    }

    private static void setConfigFlag(String key, boolean value) {
        String flag = "crockpot:" + key;
        PatchouliAPI.get().setConfigFlag(flag, value);
        FLAGS.put(flag, value);
    }

    public static String getConfigFlags() {
        return JsonUtils.GSON.toJson(FLAGS);
    }

    public static void registerPacket() {
        NetworkManager.registerPacket(PacketCrockPotConfigFlag.class, PacketCrockPotConfigFlag::serialize, PacketCrockPotConfigFlag::deserialize, PacketCrockPotConfigFlag::handle, NetworkDirection.PLAY_TO_CLIENT);
    }
}

