/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.integration.patchouli.PatchouliUtils;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.EnumUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorFoodValues
implements IComponentProcessor {
    private String categoryName;
    private Set<Item> items;
    private List<IVariable> pagedItems;

    public void setup(IVariableProvider variables) {
        this.categoryName = variables.get("category").asString();
        FoodCategory category = (FoodCategory)EnumUtils.getEnum(FoodCategory.class, (String)this.categoryName.toUpperCase());
        this.items = FoodValuesDefinition.getMatchedItems(category, Minecraft.m_91087_().f_91073_.m_7465_());
        this.pagedItems = PatchouliUtils.pagedItemVariables(this.items.stream().map(Item::m_7968_).collect(Collectors.toList()), 42);
    }

    public IVariable process(String key) {
        if (key.startsWith("item")) {
            int index = Integer.parseInt(key.substring(4)) - 1;
            if (index < 0 || index >= Math.min(this.items.size(), 42)) {
                return IVariable.from((Object)ItemStack.f_41583_);
            }
            return this.pagedItems.get(index);
        }
        if ("title".equals(key)) {
            return IVariable.from((Object)new TranslatableComponent("item.crockpot.food_category_" + this.categoryName.toLowerCase()));
        }
        return null;
    }
}

