/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.theoneprobe;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CrockPotProbeInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public ResourceLocation getID() {
        return new ResourceLocation("crockpot", "crock_pot");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData data) {
        BlockEntity blockEntity = level.m_7702_(data.getPos());
        if (blockEntity instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotTileEntity = (CrockPotBlockEntity)blockEntity;
            boolean needDrawInputs = false;
            ItemStackHandler itemHandler = crockPotTileEntity.getItemHandler();
            for (int i = 0; i < 4; ++i) {
                if (itemHandler.getStackInSlot(i).m_41619_()) continue;
                needDrawInputs = true;
                break;
            }
            if (needDrawInputs) {
                ItemStack[] inputStacks = new ItemStack[4];
                for (int i = 0; i < 4; ++i) {
                    inputStacks[i] = itemHandler.getStackInSlot(i);
                }
                IProbeInfo inputs = probeInfo.horizontal(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-6710887)).spacing(0));
                Arrays.stream(inputStacks).forEach(arg_0 -> ((IProbeInfo)inputs).item(arg_0));
                if (player.m_6144_()) {
                    IProbeInfo foodValues = probeInfo.vertical(probeInfo.defaultLayoutStyle().spacing(0));
                    FoodValues mergedFoodValues = FoodValues.merge(Arrays.stream(inputStacks).filter(stack -> !stack.m_41619_()).map(stack -> FoodValuesDefinition.getFoodValues(stack.m_41720_(), level.m_7465_())).collect(Collectors.toList()));
                    IProbeInfo foodValuesHorizontal = null;
                    int categoryCount = 0;
                    for (Pair<FoodCategory, Float> entry : mergedFoodValues.entrySet()) {
                        TextComponent suffix = new TextComponent("\u00d7" + entry.getValue());
                        if (categoryCount % 2 == 0) {
                            foodValuesHorizontal = foodValues.horizontal(probeInfo.defaultLayoutStyle().spacing(4));
                        }
                        foodValuesHorizontal.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(FoodCategory.getItemStack((FoodCategory)((Object)entry.getKey()))).text((Component)suffix);
                        ++categoryCount;
                    }
                }
            }
            if (crockPotTileEntity.isCooking()) {
                float progress;
                ItemStack result = crockPotTileEntity.getResult();
                if (!result.m_41619_()) {
                    TranslatableComponent prefix = new TranslatableComponent("integration.crockpot.top.recipe");
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)prefix).item(result).itemLabel(result);
                }
                if ((progress = crockPotTileEntity.getCookingProgress()) > 1.0E-6f) {
                    probeInfo.progress((int)(progress * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%"));
                }
            }
        }
    }
}

