/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.levelgen;

import com.google.common.collect.ImmutableSet;
import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.levelgen.CrockPotCropsFeatureConfig;
import java.util.Set;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crockpot")
public class CrockPotFeatures {
    public static final CrockPotCropsFeatureConfig ASPARAGUS_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.asparagusBlock).build();
    public static final CrockPotCropsFeatureConfig CORN_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.cornBlock).build();
    public static final CrockPotCropsFeatureConfig EGGPLANT_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.eggplantBlock).build();
    public static final CrockPotCropsFeatureConfig ONION_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.onionBlock).build();
    public static final CrockPotCropsFeatureConfig PEPPER_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.pepperBlock).whitelist((Set<Block>)ImmutableSet.of((Object)Blocks.f_50440_, (Object)Blocks.f_50546_)).build();
    public static final CrockPotCropsFeatureConfig TOMATO_PATCH_CONFIG = CrockPotCropsFeatureConfig.builder((AbstractCrockPotCropBlock)CrockPotRegistry.tomatoBlock).build();
    public static final PlacedFeature PATCH_ASPARAGUS = PlacementUtils.m_195368_((String)"patch_asparagus", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)ASPARAGUS_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.ASPARAGUS_GENERATION_CHANCE.get()))}));
    public static final PlacedFeature PATCH_CORN = PlacementUtils.m_195368_((String)"patch_corn", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)CORN_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.CORN_GENERATION_CHANCE.get()))}));
    public static final PlacedFeature PATCH_EGGPLANT = PlacementUtils.m_195368_((String)"patch_eggplant", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)EGGPLANT_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.EGGPLANT_GENERATION_CHANCE.get()))}));
    public static final PlacedFeature PATCH_ONION = PlacementUtils.m_195368_((String)"patch_onion", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)ONION_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.ONION_GENERATION_CHANCE.get()))}));
    public static final PlacedFeature PATCH_PEPPER = PlacementUtils.m_195368_((String)"patch_pepper", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)PEPPER_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.PEPPER_GENERATION_CHANCE.get()))}));
    public static final PlacedFeature PATCH_TOMATO = PlacementUtils.m_195368_((String)"patch_tomato", (PlacedFeature)CrockPotRegistry.cropsPatchFeature.m_65815_((FeatureConfiguration)TOMATO_PATCH_CONFIG).m_190823_(new PlacementModifier[]{PlacementUtils.f_195354_, RarityFilter.m_191900_((int)((Integer)CrockPotConfig.TOMATO_GENERATION_CHANCE.get()))}));

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)CrockPotConfig.ENABLE_WORLD_GENERATION.get()).booleanValue()) {
            Biome.BiomeCategory category = event.getCategory();
            BiomeGenerationSettingsBuilder builder = event.getGeneration();
            if (((Boolean)CrockPotConfig.ASPARAGUS_GENERATION.get()).booleanValue() && (event.getName().m_135815_().startsWith("dark_forest") || category == Biome.BiomeCategory.SWAMP)) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_ASPARAGUS);
            }
            if (((Boolean)CrockPotConfig.CORN_GENERATION.get()).booleanValue() && category == Biome.BiomeCategory.FOREST) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_CORN);
            }
            if (((Boolean)CrockPotConfig.EGGPLANT_GENERATION.get()).booleanValue() && (category == Biome.BiomeCategory.PLAINS || category == Biome.BiomeCategory.FOREST)) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_EGGPLANT);
            }
            if (((Boolean)CrockPotConfig.ONION_GENERATION.get()).booleanValue() && category == Biome.BiomeCategory.SAVANNA) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_ONION);
            }
            if (((Boolean)CrockPotConfig.PEPPER_GENERATION.get()).booleanValue() && (category == Biome.BiomeCategory.SAVANNA || category == Biome.BiomeCategory.MESA)) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_PEPPER);
            }
            if (((Boolean)CrockPotConfig.TOMATO_GENERATION.get()).booleanValue() && category == Biome.BiomeCategory.PLAINS) {
                builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, PATCH_TOMATO);
            }
        }
    }
}

