/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.mixin;

import com.sihenzhang.crockpot.base.CrockPotCriteriaTriggers;
import com.sihenzhang.crockpot.mixin.IPiglinMixin;
import com.sihenzhang.crockpot.recipe.bartering.PiglinBarteringRecipe;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PiglinAi.class})
public abstract class PiglinAiMixin {
    @Shadow
    private static void m_34932_(Piglin p_241427_0_, ItemStack p_241427_1_) {
    }

    @Shadow
    private static void m_34860_(Piglin p_234475_0_, List<ItemStack> p_234475_1_) {
    }

    @Shadow
    protected static boolean m_149965_(ItemStack p_149966_) {
        return true;
    }

    @Shadow
    private static void m_34938_(LivingEntity p_234501_0_) {
    }

    @Shadow
    private static boolean m_35020_(Piglin p_234451_0_) {
        return true;
    }

    @Shadow
    private static boolean m_149969_(ItemStack p_149970_) {
        return true;
    }

    @Shadow
    private static boolean m_35024_(Piglin p_234453_0_) {
        return true;
    }

    @Shadow
    private static boolean m_35028_(Piglin p_234455_0_) {
        return true;
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="HEAD")})
    private static void pickUpItemHandler(Piglin piglin, ItemEntity itemEntity, CallbackInfo ci) {
        Player player;
        Player player2 = player = itemEntity.m_32057_() != null ? piglin.f_19853_.m_46003_(itemEntity.m_32057_()) : null;
        if (player != null) {
            piglin.m_6274_().m_21879_(MemoryModuleType.f_26374_, (Object)player);
        }
    }

    @Inject(method={"pickUpItem(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;putInInventory(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/item/ItemStack;)V", ordinal=0)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void pickUpItemHandler(Piglin piglin, ItemEntity itemEntity, CallbackInfo ci, ItemStack pickedUpStack) {
        if (!PiglinAiMixin.m_149969_(pickedUpStack) && pickedUpStack.m_41720_() != Items.f_42587_ && !pickedUpStack.m_150922_((Tag)ItemTags.f_13150_) && PiglinBarteringRecipe.getRecipeFor(pickedUpStack, piglin.f_19853_.m_7465_()) != null) {
            piglin.m_6274_().m_21936_(MemoryModuleType.f_26337_);
            PiglinAiMixin.m_34932_(piglin, pickedUpStack);
            PiglinAiMixin.m_34938_((LivingEntity)piglin);
            ci.cancel();
        }
    }

    @Inject(method={"stopHoldingOffHandItem(Lnet/minecraft/world/entity/monster/piglin/Piglin;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;putInInventory(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/item/ItemStack;)V", ordinal=0)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void stopHoldingOffHandItemHandler(Piglin piglin, boolean isNotHurt, CallbackInfo ci, ItemStack offhandStack) {
        PiglinBarteringRecipe recipe;
        if (isNotHurt && !offhandStack.m_150922_((Tag)ItemTags.f_13150_) && !PiglinAiMixin.m_149969_(offhandStack) && (recipe = PiglinBarteringRecipe.getRecipeFor(offhandStack, piglin.f_19853_.m_7465_())) != null) {
            PiglinAiMixin.m_34860_(piglin, Collections.singletonList(recipe.assemble(piglin.m_21187_())));
            ci.cancel();
        }
    }

    @Inject(method={"throwItemsTowardRandomPos(Lnet/minecraft/world/entity/monster/piglin/Piglin;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void throwItemsTowardRandomPosHandler(Piglin piglin, List<ItemStack> stacks, CallbackInfo ci) {
        piglin.m_6274_().m_21952_(MemoryModuleType.f_26374_).ifPresent(livingEntity -> {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                stacks.forEach(stack -> CrockPotCriteriaTriggers.PIGLIN_BARTERING_TRIGGER.trigger(serverPlayer, (ItemStack)stack));
            }
        });
    }

    @Inject(method={"throwItemsTowardPlayer(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/entity/player/Player;Ljava/util/List;)V"}, at={@At(value="HEAD")})
    private static void throwItemsTowardPlayerHandler(Piglin piglin, Player player, List<ItemStack> stacks, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            stacks.forEach(stack -> CrockPotCriteriaTriggers.PIGLIN_BARTERING_TRIGGER.trigger(serverPlayer, (ItemStack)stack));
        }
    }

    @Inject(method={"wantsToPickup(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="JUMP", ordinal=0, opcode=166)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void wantsToPickupHandler(Piglin piglin, ItemStack wantsToPickupStack, CallbackInfoReturnable<Boolean> cir) {
        if (!(wantsToPickupStack.m_41720_() == Items.f_42587_ || PiglinAiMixin.m_149969_(wantsToPickupStack) || !PiglinAiMixin.m_149965_(wantsToPickupStack) && ((IPiglinMixin)piglin).callCanReplaceCurrentItem(wantsToPickupStack) || PiglinBarteringRecipe.getRecipeFor(wantsToPickupStack, piglin.f_19853_.m_7465_()) == null)) {
            cir.setReturnValue((Object)PiglinAiMixin.m_35028_(piglin));
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;split(I)Lnet/minecraft/world/item/ItemStack;", ordinal=0)})
    private static void modInteractHandler(Piglin piglin, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        piglin.m_6274_().m_21879_(MemoryModuleType.f_26374_, (Object)player);
    }

    @Inject(method={"canAdmire(Lnet/minecraft/world/entity/monster/piglin/Piglin;Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canAdmireHandler(Piglin piglin, ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        Predicate<ItemStack> isSpecialBarteringStack = stack -> !stack.m_150922_((Tag)ItemTags.f_13150_) && !PiglinAiMixin.m_149969_(stack) && PiglinBarteringRecipe.getRecipeFor(stack, piglin.f_19853_.m_7465_()) != null;
        cir.setReturnValue((Object)(!PiglinAiMixin.m_35024_(piglin) && !PiglinAiMixin.m_35020_(piglin) && piglin.m_34667_() && (itemStack.isPiglinCurrency() || isSpecialBarteringStack.test(itemStack)) ? 1 : 0));
    }

    @Inject(method={"isPlayerHoldingLovedItem(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isPlayerHoldingLovedItemHandler(LivingEntity livingEntity, CallbackInfoReturnable<Boolean> cir) {
        Predicate<ItemStack> isSpecialBarteringItem = stack -> !stack.m_150922_((Tag)ItemTags.f_13150_) && !PiglinAiMixin.m_149969_(stack) && PiglinBarteringRecipe.getRecipeFor(stack, livingEntity.f_19853_.m_7465_()) != null;
        cir.setReturnValue((Object)(livingEntity.m_6095_() == EntityType.f_20532_ && (livingEntity.m_21093_(PiglinAiMixin::m_149965_) || livingEntity.m_21093_(isSpecialBarteringItem)) ? 1 : 0));
    }

    @Inject(method={"isNotHoldingLovedItemInOffHand(Lnet/minecraft/world/entity/monster/piglin/Piglin;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isNotHoldingLovedItemInOffHandHandler(Piglin piglin, CallbackInfoReturnable<Boolean> cir) {
        ItemStack offhandStack = piglin.m_21206_();
        Predicate<ItemStack> isSpecialBarteringStack = stack -> !stack.m_150922_((Tag)ItemTags.f_13150_) && !PiglinAiMixin.m_149969_(stack) && PiglinBarteringRecipe.getRecipeFor(stack, piglin.f_19853_.m_7465_()) != null;
        cir.setReturnValue((Object)(offhandStack.m_41619_() || !PiglinAiMixin.m_149965_(offhandStack) && !isSpecialBarteringStack.test(offhandStack) ? 1 : 0));
    }
}

