/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipeTypes;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrockPotCookingRecipe
extends AbstractCrockPotRecipe {
    private final List<IRequirement> requirements;
    private final ItemStack result;
    private final int priority;
    private final int weight;
    private final int cookingTime;
    private final int potLevel;

    public CrockPotCookingRecipe(ResourceLocation id, List<IRequirement> requirements, ItemStack result, int priority, int weight, int cookingTime, int potLevel) {
        super(id);
        this.requirements = ImmutableList.copyOf(requirements);
        this.result = result;
        this.priority = priority;
        this.weight = Math.max(weight, 1);
        this.cookingTime = cookingTime;
        this.potLevel = potLevel;
    }

    public List<IRequirement> getRequirements() {
        return this.requirements;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    public boolean matches(CrockPotCookingRecipeInput input) {
        return input.potLevel >= this.potLevel && this.requirements.stream().allMatch(r -> r.test(input));
    }

    @Nullable
    public static CrockPotCookingRecipe getRecipeFor(CrockPotCookingRecipeInput input, Random random, RecipeManager recipeManager) {
        List recipes = recipeManager.m_44013_(CrockPotRecipeTypes.CROCK_POT_COOKING_RECIPE_TYPE);
        recipes.sort(Comparator.comparing(CrockPotCookingRecipe::getPriority).reversed());
        SimpleWeightedRandomList.Builder matchedRecipes = SimpleWeightedRandomList.m_146263_();
        boolean isFirst = true;
        int priority = 0;
        for (CrockPotCookingRecipe recipe : recipes) {
            if (isFirst) {
                if (!recipe.matches(input)) continue;
                priority = recipe.getPriority();
                matchedRecipes.m_146271_((Object)recipe, recipe.getWeight());
                isFirst = false;
                continue;
            }
            if (recipe.getPriority() != priority) break;
            if (!recipe.matches(input)) continue;
            matchedRecipes.m_146271_((Object)recipe, recipe.getWeight());
        }
        return matchedRecipes.m_146270_().m_146266_(random).orElse(null);
    }

    public ItemStack assemble() {
        return this.result.m_41777_();
    }

    @Override
    public ItemStack m_8043_() {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return CrockPotRegistry.crockPotCooking;
    }

    public RecipeType<?> m_6671_() {
        return CrockPotRecipeTypes.CROCK_POT_COOKING_RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CrockPotCookingRecipe> {
        public CrockPotCookingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
            GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"requirements").forEach(requirement -> requirements.add(IRequirement.fromJson(requirement)));
            ItemStack result = JsonUtils.getAsItemStack(serializedRecipe, "result");
            int priority = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"priority");
            int weight = GsonHelper.m_13824_((JsonObject)serializedRecipe, (String)"weight", (int)1);
            int cookingTime = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"cookingtime");
            int potLevel = GsonHelper.m_13927_((JsonObject)serializedRecipe, (String)"potlevel");
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        @Nullable
        public CrockPotCookingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
            int length = buffer.m_130242_();
            for (int i = 0; i < length; ++i) {
                requirements.add(IRequirement.fromNetwork(buffer));
            }
            ItemStack result = buffer.m_130267_();
            int priority = buffer.m_130242_();
            int weight = buffer.m_130242_();
            int cookingTime = buffer.m_130242_();
            byte potLevel = buffer.readByte();
            return new CrockPotCookingRecipe(recipeId, requirements, result, priority, weight, cookingTime, potLevel);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrockPotCookingRecipe recipe) {
            buffer.m_130130_(recipe.getRequirements().size());
            recipe.getRequirements().forEach(requirement -> requirement.toNetwork(buffer));
            buffer.m_130055_(recipe.getResult());
            buffer.m_130130_(recipe.getPriority());
            buffer.m_130130_(recipe.getWeight());
            buffer.m_130130_(recipe.getCookingTime());
            buffer.writeByte(recipe.getPotLevel());
        }
    }
}

