/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;

public final class JsonUtils {
    public static final Gson GSON = new GsonBuilder().create();

    @Nullable
    public static Item convertToItem(JsonElement json, String memberName) {
        if (GsonHelper.m_13803_((JsonElement)json)) {
            String s = json.getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            return item == Items.f_41852_ ? null : item;
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    @Nullable
    public static Item getAsItem(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonUtils.convertToItem(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
    }

    public static ItemStack convertToItemStack(JsonElement json, String memberName) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            return ShapedRecipe.m_151274_((JsonObject)object);
        }
        if (GsonHelper.m_13803_((JsonElement)json)) {
            Item item = GsonHelper.m_13874_((JsonElement)json, (String)memberName);
            return item.m_7968_();
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an item stack, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static ItemStack getAsItemStack(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return JsonUtils.convertToItemStack(json.get(memberName), memberName);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item stack");
    }

    @Nonnull
    public static Ingredient getAsIngredient(JsonObject json, String memberName) {
        return JsonUtils.getAsIngredient(json, memberName, false);
    }

    public static Ingredient getAsIngredient(JsonObject json, String memberName, boolean skip) {
        if (json.has(memberName)) {
            if (skip) {
                if (json.get(memberName).isJsonArray()) {
                    JsonArray array = json.getAsJsonArray(memberName);
                    JsonArray result = new JsonArray();
                    for (JsonElement e : array) {
                        JsonObject obj = GsonHelper.m_13918_((JsonElement)e, (String)"item");
                        if (obj.has("item") && obj.has("tag")) {
                            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
                        }
                        if (obj.has("item")) {
                            name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"item"));
                            Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
                            if (item == null || item == Items.f_41852_) {
                                continue;
                            }
                        } else if (obj.has("tag")) {
                            name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)obj, (String)"tag"));
                            Tag tag = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_13404_(name);
                            if (tag == null) {
                                continue;
                            }
                        } else {
                            throw new JsonParseException("An ingredient entry needs either a tag or an item");
                        }
                        result.add(e);
                    }
                    return Ingredient.m_43917_((JsonElement)result);
                }
                return Ingredient.m_43917_((JsonElement)json.get(memberName));
            }
            return Ingredient.m_43917_((JsonElement)json.get(memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an ingredient");
    }

    public static <E extends Enum<E>> E convertToEnum(JsonElement json, String memberName, Class<E> enumClass) {
        if (GsonHelper.m_13803_((JsonElement)json)) {
            String enumName = GsonHelper.m_13805_((JsonElement)json, (String)memberName).toUpperCase();
            if (!EnumUtils.isValidEnum(enumClass, (String)enumName)) {
                throw new JsonSyntaxException("Expected " + memberName + " to be an enum of " + enumClass.getName() + ", was unknown name: '" + enumName + "'");
            }
            return (E)EnumUtils.getEnum(enumClass, (String)enumName);
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an enum of " + enumClass.getName() + ", was" + GsonHelper.m_13883_((JsonElement)json));
    }

    public static <E extends Enum<E>> E getAsEnum(JsonObject json, String memberName, Class<E> enumClass) {
        if (json.has(memberName)) {
            return JsonUtils.convertToEnum(json.get(memberName), memberName, enumClass);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an enum");
    }
}

