/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.base;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sihenzhang.crockpot.base.FoodCategory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FoodValues {
    private static final FoodCategory[] CATEGORIES = FoodCategory.values();
    private final float[] values = new float[CATEGORIES.length];
    private int size;

    private FoodValues() {
    }

    public static FoodValues create() {
        return new FoodValues();
    }

    @SafeVarargs
    public static FoodValues of(Pair<FoodCategory, Float> ... pairs) {
        FoodValues foodValues = FoodValues.create();
        for (Pair<FoodCategory, Float> pair : pairs) {
            foodValues.put((FoodCategory)((Object)pair.getKey()), ((Float)pair.getValue()).floatValue());
        }
        return foodValues;
    }

    public static FoodValues of(Object ... categoriesAndValues) {
        FoodValues foodValues = FoodValues.create();
        FoodCategory category = null;
        for (int i = 0; i < categoriesAndValues.length; ++i) {
            if (i % 2 == 0) {
                category = (FoodCategory)((Object)categoriesAndValues[i]);
                continue;
            }
            foodValues.put(category, ((Float)categoriesAndValues[i]).floatValue());
        }
        return foodValues;
    }

    public static FoodValues of(Map<FoodCategory, Float> map) {
        FoodValues foodValues = FoodValues.create();
        if (map != null) {
            map.forEach(foodValues::put);
        }
        return foodValues;
    }

    public static FoodValues merge(Collection<FoodValues> foodValues) {
        FoodValues mergedFoodValues = FoodValues.create();
        foodValues.forEach(foodValue -> foodValue.entrySet().forEach(entry -> mergedFoodValues.put((FoodCategory)((Object)((Object)((Object)entry.getKey()))), ((Float)entry.getValue()).floatValue() + mergedFoodValues.get((FoodCategory)((Object)((Object)((Object)entry.getKey())))))));
        return mergedFoodValues;
    }

    public FoodValues set(FoodCategory category, float value) {
        this.put(category, value);
        return this;
    }

    public float get(FoodCategory category) {
        if (category == null) {
            return 0.0f;
        }
        return Math.max(this.values[category.ordinal()], 0.0f);
    }

    public boolean has(FoodCategory category) {
        if (category == null) {
            return false;
        }
        return this.values[category.ordinal()] > 0.0f;
    }

    public void put(FoodCategory category, float value) {
        if (category == null) {
            return;
        }
        if (Float.isNaN(value) || value <= 0.0f) {
            this.remove(category);
            return;
        }
        boolean hasOldValue = this.has(category);
        this.values[category.ordinal()] = value;
        if (!hasOldValue) {
            ++this.size;
        }
    }

    public void remove(FoodCategory category) {
        if (category == null || !this.has(category)) {
            return;
        }
        this.values[category.ordinal()] = 0.0f;
        --this.size;
    }

    public void clear() {
        Arrays.fill(this.values, 0.0f);
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int size() {
        return this.size;
    }

    public Set<Pair<FoodCategory, Float>> entrySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < this.values.length; ++i) {
            if (!(this.values[i] > 0.0f)) continue;
            builder.add((Object)Pair.of((Object)((Object)CATEGORIES[i]), (Object)Float.valueOf(this.values[i])));
        }
        return builder.build();
    }

    public static FoodValues fromJson(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected food value to be an object, was " + GsonHelper.m_13883_((JsonElement)json));
        }
        FoodValues foodValues = FoodValues.create();
        JsonObject obj = json.getAsJsonObject();
        obj.entrySet().forEach(entry -> {
            String category = ((String)entry.getKey()).toUpperCase();
            if (!EnumUtils.isValidEnum(FoodCategory.class, (String)category)) {
                throw new JsonSyntaxException("Expected the key of food value to be an enum of food category, was unknown name: '" + category + "'");
            }
            if (!GsonHelper.m_13872_((JsonElement)((JsonElement)entry.getValue()))) {
                throw new JsonSyntaxException("Expected the value of food value to be a number, was " + GsonHelper.m_13883_((JsonElement)((JsonElement)entry.getValue())));
            }
            foodValues.put(FoodCategory.valueOf(category), ((JsonElement)entry.getValue()).getAsFloat());
        });
        return foodValues;
    }

    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        this.entrySet().forEach(entry -> obj.addProperty(((FoodCategory)((Object)((Object)entry.getKey()))).name(), (Number)entry.getValue()));
        return obj;
    }

    public static FoodValues fromNetwork(FriendlyByteBuf buffer) {
        FoodValues foodValues = FoodValues.create();
        int length = buffer.readByte();
        for (int i = 0; i < length; ++i) {
            FoodCategory category = (FoodCategory)buffer.m_130066_(FoodCategory.class);
            float value = buffer.readFloat();
            foodValues.put(category, value);
        }
        return foodValues;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        Set<Pair<FoodCategory, Float>> entrySet = this.entrySet();
        buffer.writeByte(entrySet.size());
        entrySet.forEach(entry -> {
            buffer.m_130068_((Enum)entry.getKey());
            buffer.writeFloat(((Float)entry.getValue()).floatValue());
        });
    }
}

