/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.entity.BirdcageBlockEntity;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntities;
import com.sihenzhang.crockpot.entity.Birdcage;
import com.sihenzhang.crockpot.entity.CrockPotEntities;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.recipe.ParrotFeedingRecipe;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BirdcageBlock
extends BaseEntityBlock {
    public static final VoxelShape LOWER_SHAPE_WITHOUT_BASE = Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape LOWER_SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), LOWER_SHAPE_WITHOUT_BASE});
    public static final VoxelShape UPPER_SHAPE_WITHOUT_CHAIN = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
    public static final VoxelShape UPPER_SHAPE = Shapes.m_83110_((VoxelShape)UPPER_SHAPE_WITHOUT_CHAIN, (VoxelShape)Block.m_49796_((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)13.0, (double)9.5));
    public static final VoxelShape HANGING_UPPER_SHAPE = Shapes.m_83110_((VoxelShape)UPPER_SHAPE_WITHOUT_CHAIN, (VoxelShape)Block.m_49796_((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5));
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;

    public BirdcageBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76366_).m_60999_().m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56762_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = this.getBlockEntity((BlockGetter)pLevel, pPos, pState);
        if (blockEntity instanceof BirdcageBlockEntity) {
            BirdcageBlockEntity birdcageBlockEntity = (BirdcageBlockEntity)blockEntity;
            BlockPos lowerPos = pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos : pPos.m_7495_();
            List parrots = pLevel.m_45976_(Parrot.class, new AABB((double)lowerPos.m_123341_(), (double)lowerPos.m_123342_(), (double)lowerPos.m_123343_(), (double)lowerPos.m_123341_() + 1.0, (double)lowerPos.m_123342_() + 2.0, (double)lowerPos.m_123343_() + 1.0));
            ItemStack stackInHand = pPlayer.m_21120_(pHand);
            if (parrots.isEmpty()) {
                if (pHand == InteractionHand.MAIN_HAND && stackInHand.m_41619_()) {
                    CompoundTag leftShoulderEntity = pPlayer.m_36331_();
                    CompoundTag rightShoulderEntity = pPlayer.m_36332_();
                    if (!leftShoulderEntity.m_128456_() || !rightShoulderEntity.m_128456_()) {
                        boolean isLeftShoulder;
                        boolean bl = isLeftShoulder = !leftShoulderEntity.m_128456_();
                        Optional<Parrot> optionalParrot = EntityType.m_20642_((CompoundTag)(isLeftShoulder ? leftShoulderEntity : rightShoulderEntity), (Level)pLevel).filter(Parrot.class::isInstance).map(Parrot.class::cast);
                        Optional<Birdcage> optionalBirdcage = Optional.ofNullable((Birdcage)((EntityType)CrockPotEntities.BIRDCAGE.get()).m_20615_(pLevel));
                        if (optionalParrot.isPresent() && optionalBirdcage.isPresent()) {
                            Parrot parrot = optionalParrot.get();
                            Birdcage birdcage = optionalBirdcage.get();
                            if (!pLevel.m_5776_() && birdcageBlockEntity.captureParrot(pLevel, lowerPos, pPlayer, parrot, birdcage, isLeftShoulder)) {
                                return InteractionResult.SUCCESS;
                            }
                            return InteractionResult.CONSUME;
                        }
                    }
                }
            } else {
                if (pHand == InteractionHand.MAIN_HAND && stackInHand.m_41619_() && pPlayer.m_20161_()) {
                    for (Parrot parrot : parrots) {
                        if (!pPlayer.m_142081_().equals(parrot.m_142504_())) continue;
                        if (!pLevel.m_5776_() && parrot.m_29895_((ServerPlayer)pPlayer)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.CONSUME;
                    }
                }
                Parrot parrot = (Parrot)parrots.get(0);
                if (!birdcageBlockEntity.isOnCooldown()) {
                    FoodValues foodValues = FoodValuesDefinition.getFoodValues(stackInHand.m_41720_(), pLevel.m_7465_());
                    if (foodValues.has(FoodCategory.MEAT)) {
                        if (!pLevel.m_5776_() && birdcageBlockEntity.fedByMeat(pPlayer.m_150110_().f_35937_ ? stackInHand.m_41777_() : stackInHand, foodValues, parrot)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.CONSUME;
                    }
                    Optional optionalParrotFeedingRecipe = pLevel.m_7465_().m_44015_((RecipeType)CrockPotRecipes.PARROT_FEEDING_RECIPE_TYPE.get(), (Container)new SimpleContainer(new ItemStack[]{stackInHand}), pLevel);
                    if (optionalParrotFeedingRecipe.isPresent()) {
                        if (!pLevel.m_5776_() && birdcageBlockEntity.fedByRecipe(pPlayer.m_150110_().f_35937_ ? stackInHand.m_41777_() : stackInHand, (ParrotFeedingRecipe)optionalParrotFeedingRecipe.get(), parrot)) {
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.CONSUME;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (!pLevel.m_5776_() && pPlayer.m_7500_() && pState.m_61143_(HALF) == DoubleBlockHalf.UPPER && (lowerState = pLevel.m_8055_(lowerPos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            if (pState.m_61138_(HALF) && pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                pLevel.m_45976_(Birdcage.class, new AABB((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (double)pPos.m_123341_() + 1.0, (double)pPos.m_123342_() + 2.0, (double)pPos.m_123343_() + 1.0)).forEach(Entity::m_146870_);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == BirdcageBlock.getConnectedDirection(pState)) {
            return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(HALF) != pState.m_61143_(HALF) ? pState : Blocks.f_50016_.m_49966_();
        }
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            boolean lowerBlockHangingValueWithSupport;
            boolean canSupport;
            boolean upperBlockHangingValueWithSupport = canSupport = Block.m_49863_((LevelReader)pLevel, (BlockPos)pNeighborPos, (Direction)pDirection.m_122424_());
            boolean bl = lowerBlockHangingValueWithSupport = !canSupport;
            if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER && (Boolean)pState.m_61143_((Property)HANGING) != lowerBlockHangingValueWithSupport) {
                return (BlockState)pState.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(lowerBlockHangingValueWithSupport));
            }
            if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER && (Boolean)pState.m_61143_((Property)HANGING) != upperBlockHangingValueWithSupport) {
                return (BlockState)pState.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(upperBlockHangingValueWithSupport));
            }
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        for (Direction direction : pContext.m_6232_()) {
            boolean lowerBlockHangingValueWithSupport;
            boolean canSupport;
            if (direction.m_122434_() != Direction.Axis.Y) continue;
            boolean upperBlockHangingValueWithSupport = canSupport = Block.m_49863_((LevelReader)level, (BlockPos)clickedPos.m_142300_(direction), (Direction)direction.m_122424_());
            boolean bl = lowerBlockHangingValueWithSupport = !canSupport;
            if (direction == Direction.UP) {
                if (clickedPos.m_123342_() <= level.m_141937_() || !level.m_8055_(clickedPos.m_7495_()).m_60629_(pContext)) continue;
                return (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(upperBlockHangingValueWithSupport));
            }
            if (clickedPos.m_123342_() >= level.m_151558_() - 1 || !level.m_8055_(clickedPos.m_7494_()).m_60629_(pContext)) continue;
            return (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(lowerBlockHangingValueWithSupport));
        }
        return null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        Direction neighbourDirection = BirdcageBlock.getConnectedDirection(pState);
        BlockPos neighbourPos = pPos.m_142300_(neighbourDirection);
        boolean neighbourCanSupport = Block.m_49863_((LevelReader)pLevel, (BlockPos)neighbourPos.m_142300_(neighbourDirection), (Direction)neighbourDirection.m_122424_());
        pLevel.m_46597_(neighbourPos, (BlockState)((BlockState)pState.m_61124_(HALF, (Comparable)(pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(neighbourDirection == Direction.UP == neighbourCanSupport)));
    }

    public static Direction getConnectedDirection(BlockState pState) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.m_61143_((Property)HANGING)).booleanValue()) {
            return pState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? HANGING_UPPER_SHAPE : LOWER_SHAPE_WITHOUT_BASE;
        }
        return pState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HALF, HANGING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? new BirdcageBlockEntity(pPos, pState) : null;
    }

    public BlockEntity getBlockEntity(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.m_7702_(pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos : pPos.m_7495_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.m_5776_() ? null : BirdcageBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)CrockPotBlockEntities.BIRDCAGE_BLOCK_ENTITY.get()), BirdcageBlockEntity::serverTick);
    }
}

