/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntities;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.item.CrockPotItems;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class CrockPotBlock
extends BaseEntityBlock {
    private static final Random RAND = new Random();
    private static final String[] SUFFIXES = new String[]{"Pro", "Plus", "Max", "Ultra", "Premium", "Super"};
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    private long lastSysTime;
    private final Set<Integer> toPick = new HashSet<Integer>();
    private final int potLevel;

    public CrockPotBlock(int potLevel) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(1.5f, 6.0f).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 13 : 0).m_60955_());
        this.potLevel = potLevel;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrockPotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : CrockPotBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)CrockPotBlockEntities.CROCK_POT_BLOCK_ENTITY.get()), CrockPotBlockEntity::serverTick);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotBlockEntity = (CrockPotBlockEntity)blockEntity;
            crockPotBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)((double)pPos.m_123342_() + 0.5), (double)pPos.m_123343_(), (ItemStack)stack);
                }
            });
            if (crockPotBlockEntity.isCooking()) {
                Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)((double)pPos.m_123342_() + 0.5), (double)pPos.m_123343_(), (ItemStack)((Item)CrockPotItems.WET_GOOP.get()).m_7968_());
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotBlockEntity = (CrockPotBlockEntity)blockEntity;
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)crockPotBlockEntity, (BlockPos)pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double xPos = (double)pos.m_123341_() + 0.5;
            double yPos = (double)pos.m_123342_() + 0.2;
            double zPos = (double)pos.m_123343_() + 0.5;
            if (random.nextInt(10) == 0) {
                level.m_7785_(xPos, yPos, zPos, SoundEvents.f_11784_, SoundSource.BLOCKS, random.nextFloat() + 0.5f, Mth.m_14068_((Random)random, (float)0.6f, (float)1.3f), false);
            }
            if (this.potLevel == 2) {
                Direction direction = (Direction)state.m_61143_((Property)FACING);
                Direction.Axis directionAxis = direction.m_122434_();
                double axisOffset = Mth.m_14064_((Random)random, (double)-0.15, (double)0.15);
                double xOffset = directionAxis == Direction.Axis.X ? (double)direction.m_122429_() * 0.45 : axisOffset;
                double yOffset = Mth.m_14064_((Random)random, (double)-0.15, (double)0.15);
                double zOffset = directionAxis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.45 : axisOffset;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123808_, xPos + xOffset, yPos + yOffset, zPos + zOffset, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123808_, xPos - xOffset, yPos + yOffset, zPos - zOffset, 0.0, 0.0, 0.0);
            } else {
                double xOffset = Mth.m_14064_((Random)random, (double)-0.15, (double)0.15);
                double zOffset = Mth.m_14064_((Random)random, (double)-0.15, (double)0.15);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
            }
        }
    }

    public MutableComponent m_49954_() {
        if (this.potLevel > 0) {
            long sysTime = System.currentTimeMillis();
            if (this.lastSysTime + 5000L < sysTime) {
                this.lastSysTime = sysTime;
                this.toPick.clear();
                while (this.toPick.size() < this.potLevel) {
                    this.toPick.add(RAND.nextInt(SUFFIXES.length));
                }
            }
            Object[] toPickSuffixes = this.toPick.stream().map(i -> new TextComponent(SUFFIXES[i])).toArray();
            return new TranslatableComponent(this.m_7705_(), toPickSuffixes);
        }
        return super.m_49954_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.8f;
    }
}

