/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.block.AbstractCrockPotDoubleCropBlock;
import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.tag.CrockPotBlockTags;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class UnknownCropsBlock
extends AbstractCrockPotCropBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61405_;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.m_7959_())];
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        float growthChance;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        List unknownCropsBlocks = ForgeRegistries.BLOCKS.tags().getTag(CrockPotBlockTags.UNKNOWN_CROPS).stream().toList();
        if (unknownCropsBlocks.isEmpty()) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthChance = UnknownCropsBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, ((Block)unknownCropsBlocks.get(level.f_46441_.nextInt(unknownCropsBlocks.size()))).m_49966_(), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_52263_(Level level, BlockPos pos, BlockState state) {
        List unknownCropsBlocks = ForgeRegistries.BLOCKS.tags().getTag(CrockPotBlockTags.UNKNOWN_CROPS).stream().toList();
        if (unknownCropsBlocks.isEmpty()) {
            return;
        }
        Block block = (Block)unknownCropsBlocks.get(level.f_46441_.nextInt(unknownCropsBlocks.size()));
        int age = this.m_7125_(level) - 1;
        if (block instanceof AbstractCrockPotDoubleCropBlock) {
            AbstractCrockPotDoubleCropBlock cropBlock = (AbstractCrockPotDoubleCropBlock)block;
            int maxAge = cropBlock.getMaxGrowthAge(cropBlock.m_49966_());
            if (age > maxAge) {
                level.m_7731_(pos, cropBlock.m_52289_(maxAge), 2);
                if (level.m_46859_(pos.m_7494_())) {
                    level.m_7731_(pos.m_7494_(), cropBlock.m_52289_(age), 2);
                }
            } else {
                level.m_7731_(pos, cropBlock.m_52289_(age), 2);
            }
        } else if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            level.m_7731_(pos, cropBlock.m_52289_(Math.min(age, cropBlock.m_7419_())), 2);
        } else {
            level.m_7731_(pos, block.m_49966_(), 2);
        }
    }

    @Override
    protected ItemLike m_6404_() {
        return (ItemLike)CrockPotItems.UNKNOWN_SEEDS.get();
    }
}

