/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block.entity;

import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntities;
import com.sihenzhang.crockpot.entity.Birdcage;
import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.recipe.ParrotFeedingRecipe;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BirdcageBlockEntity
extends BlockEntity {
    private static final int FED_COOLDOWN = 10;
    private static final int OUTPUT_COOLDOWN = 40;
    private int fedCooldown;
    private final Queue<Pair<ItemStack, Long>> outputBuffer = new ArrayDeque<Pair<ItemStack, Long>>(4);

    public BirdcageBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)CrockPotBlockEntities.BIRDCAGE_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, BirdcageBlockEntity pBlockEntity) {
        if (pBlockEntity.isOnCooldown()) {
            --pBlockEntity.fedCooldown;
        }
        while (!pBlockEntity.outputBuffer.isEmpty() && (Long)pBlockEntity.outputBuffer.peek().getSecond() < pLevel.m_46467_()) {
            ItemStack output = (ItemStack)pBlockEntity.outputBuffer.poll().getFirst();
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new SimpleContainer(new ItemStack[]{output}));
        }
    }

    public boolean isOnCooldown() {
        return this.fedCooldown > 0;
    }

    public boolean captureParrot(Level pLevel, BlockPos pPos, Player pPlayer, Parrot pParrot, Birdcage pBirdcage, boolean isLeftShoulder) {
        pParrot.m_21816_(pPlayer.m_142081_());
        pParrot.m_6034_(pPlayer.m_20185_(), pPlayer.m_20186_() + 0.7, pPlayer.m_20189_());
        pLevel.m_7967_((Entity)pParrot);
        pBirdcage.m_6034_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.475, (double)pPos.m_123343_() + 0.5);
        pLevel.m_7967_((Entity)pBirdcage);
        if (!pParrot.m_7998_((Entity)pBirdcage, true)) {
            pParrot.m_146870_();
            pBirdcage.m_146870_();
            return false;
        }
        if (isLeftShoulder) {
            pPlayer.m_36362_(new CompoundTag());
        } else {
            pPlayer.m_36364_(new CompoundTag());
        }
        return true;
    }

    public boolean fedByMeat(ItemStack meat, FoodValues foodValues, Parrot parrot) {
        if (this.isOnCooldown()) {
            return false;
        }
        if (meat.m_41619_()) {
            return false;
        }
        boolean isMonsterFood = foodValues.has(FoodCategory.MONSTER);
        if (!isMonsterFood || this.f_58857_.f_46441_.nextBoolean()) {
            ItemStack parrotEgg = ((Item)CrockPotItems.PARROT_EGGS.get(parrot.m_29440_()).get()).m_7968_();
            this.outputBuffer.offer((Pair<ItemStack, Long>)Pair.of((Object)parrotEgg, (Object)(this.f_58857_.m_46467_() + 40L)));
        }
        meat.m_41774_(1);
        this.fedCooldown = 10;
        if (!parrot.m_20067_()) {
            this.f_58857_.m_6263_(null, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), SoundEvents.f_11912_, parrot.m_5720_(), 1.0f, isMonsterFood ? 0.75f : 1.25f);
        }
        this.f_58857_.m_7605_((Entity)parrot, (byte)6);
        return true;
    }

    public boolean fedByRecipe(ItemStack input, ParrotFeedingRecipe recipe, Parrot parrot) {
        if (this.isOnCooldown()) {
            return false;
        }
        if (input.m_41619_()) {
            return false;
        }
        ItemStack result = recipe.m_5874_((Container)new SimpleContainer(new ItemStack[]{input}));
        if (result.m_41619_()) {
            return false;
        }
        this.outputBuffer.offer((Pair<ItemStack, Long>)Pair.of((Object)result, (Object)(this.f_58857_.m_46467_() + 40L)));
        input.m_41774_(1);
        this.fedCooldown = 10;
        if (!parrot.m_20067_()) {
            this.f_58857_.m_6263_(null, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), SoundEvents.f_12190_, parrot.m_5720_(), 1.0f, 1.0f);
        }
        this.f_58857_.m_7605_((Entity)parrot, (byte)7);
        return true;
    }
}

