/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client.model;

import com.google.common.collect.ImmutableList;
import com.sihenzhang.crockpot.util.RLUtils;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;

public class MilkmadeHatModel<T extends LivingEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(RLUtils.createRL("milkmade_hat"), "main");
    private final ModelPart hat;
    protected float swimAmount;

    public MilkmadeHatModel(ModelPart root) {
        this.hat = root.m_171324_("hat");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition hat = partDefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-5.0f, -9.0f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -7.99f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)).m_171514_(32, 0).m_171488_(-4.0f, -9.01f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bottle1 = hat.m_171599_("bottle1", CubeListBuilder.m_171558_().m_171514_(56, 16).m_171480_().m_171488_(-8.05f, -4.5f, -1.25f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 16).m_171480_().m_171488_(-9.05f, -11.5f, -2.25f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 16).m_171480_().m_171488_(-8.06f, -9.5f, -1.25f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 24).m_171480_().m_171488_(-10.05f, -8.5f, -3.25f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.01f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition straw1 = bottle1.m_171599_("straw1", CubeListBuilder.m_171558_().m_171514_(60, 19).m_171488_(-11.6f, -31.4f, -0.75f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)28.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition straw2 = bottle1.m_171599_("straw2", CubeListBuilder.m_171558_().m_171514_(56, 19).m_171488_(-3.6f, -31.4f, -0.74f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)28.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition bottle2 = hat.m_171599_("bottle2", CubeListBuilder.m_171558_().m_171514_(56, 16).m_171488_(6.05f, -4.5f, -1.25f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(30, 16).m_171488_(5.05f, -11.5f, -2.25f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 16).m_171488_(6.06f, -9.5f, -1.25f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 24).m_171488_(4.05f, -8.5f, -3.25f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition straw3 = bottle2.m_171599_("straw3", CubeListBuilder.m_171558_().m_171514_(60, 19).m_171480_().m_171488_(10.6f, -31.4f, -0.75f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)28.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition straw4 = bottle2.m_171599_("straw4", CubeListBuilder.m_171558_().m_171514_(56, 19).m_171480_().m_171488_(2.6f, -31.4f, -0.74f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)28.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.hat);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of();
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.swimAmount = entity.m_20998_(partialTick);
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            this.hat.m_171327_((float)Math.PI / 180 * armorStand.m_31680_().m_123156_(), (float)Math.PI / 180 * armorStand.m_31680_().m_123157_(), (float)Math.PI / 180 * armorStand.m_31680_().m_123158_());
            this.hat.m_104227_(0.0f, 1.0f, 0.0f);
        } else {
            this.hat.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.hat.f_104203_ = entity.m_21256_() > 4 ? -0.7853982f : (this.swimAmount > 0.0f ? (entity.m_6067_() ? this.rotlerpRad(this.swimAmount, this.hat.f_104203_, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.hat.f_104203_, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
            this.hat.f_104201_ = entity.m_6047_() ? 4.2f : 0.0f;
        }
    }

    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }
}

