/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sihenzhang.crockpot.client.model.MilkmadeHatModel;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.util.RLUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MilkmadeHatLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation MILKMADE_HAT_TEXTURE = RLUtils.createRL("textures/entity/milkmade_hat.png");
    private final MilkmadeHatModel<T> milkmadeHatModel;

    public MilkmadeHatLayer(RenderLayerParent<T, M> renderer, EntityModelSet entityModelSet) {
        super(renderer);
        this.milkmadeHatModel = new MilkmadeHatModel(entityModelSet.m_171103_(MilkmadeHatModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stackBySlot = livingEntity.m_6844_(EquipmentSlot.HEAD);
        if (stackBySlot.m_41720_() instanceof MilkmadeHatItem) {
            this.m_117386_().m_102624_(this.milkmadeHatModel);
            this.milkmadeHatModel.prepareMobModel(livingEntity, limbSwing, limbSwingAmount, partialTicks);
            this.milkmadeHatModel.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)MILKMADE_HAT_TEXTURE), (boolean)false, (boolean)stackBySlot.m_41790_());
            this.milkmadeHatModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

