/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data;

import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.util.RLUtils;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CrockPotItemModelProvider
extends ItemModelProvider {
    public CrockPotItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "crockpot", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem((Item)CrockPotItems.UNKNOWN_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.ASPARAGUS_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.ASPARAGUS.get());
        this.simpleItem((Item)CrockPotItems.CORN_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.CORN.get());
        this.simpleItem((Item)CrockPotItems.POPCORN.get());
        this.simpleItem((Item)CrockPotItems.EGGPLANT_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.EGGPLANT.get());
        this.simpleItem((Item)CrockPotItems.COOKED_EGGPLANT.get());
        this.simpleItem((Item)CrockPotItems.GARLIC_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.GARLIC.get());
        this.simpleItem((Item)CrockPotItems.ONION_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.ONION.get());
        this.simpleItem((Item)CrockPotItems.PEPPER_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.PEPPER.get());
        this.simpleItem((Item)CrockPotItems.TOMATO_SEEDS.get());
        this.simpleItem((Item)CrockPotItems.TOMATO.get());
        this.simpleItem((Item)CrockPotItems.BIRDCAGE.get());
        this.simpleItem((Item)CrockPotItems.BREAKFAST_SKILLET.get());
        this.simpleItem((Item)CrockPotItems.GLOW_BERRY_MOUSSE.get());
        this.simpleItem((Item)CrockPotItems.PLAIN_OMELETTE.get());
        this.simpleItem((Item)CrockPotItems.SCOTCH_EGG.get());
    }

    public ItemModelBuilder blockItem(Block block) {
        return this.blockItem(block, RLUtils.createRL("block/" + CrockPotItemModelProvider.getBlockName(block)));
    }

    public ItemModelBuilder blockItem(Block block, ResourceLocation model) {
        return (ItemModelBuilder)this.withExistingParent(CrockPotItemModelProvider.getBlockName(block), model);
    }

    public ItemModelBuilder simpleItem(Item item) {
        return this.simpleItem(item, RLUtils.createRL("item/" + CrockPotItemModelProvider.getItemName((ItemLike)item)));
    }

    public ItemModelBuilder simpleItem(Item item, ResourceLocation texture) {
        return this.item(CrockPotItemModelProvider.getItemName((ItemLike)item), texture);
    }

    public ItemModelBuilder item(String name, ResourceLocation texture) {
        return (ItemModelBuilder)this.singleTexture(name, RLUtils.createVanillaRL("item/generated"), "layer0", texture);
    }

    public ItemModelBuilder simpleHandheldItem(Item item) {
        return this.simpleHandheldItem(item, RLUtils.createRL("item/" + CrockPotItemModelProvider.getItemName((ItemLike)item)));
    }

    public ItemModelBuilder simpleHandheldItem(Item item, ResourceLocation texture) {
        return this.handheldItem(CrockPotItemModelProvider.getItemName((ItemLike)item), texture);
    }

    public ItemModelBuilder handheldItem(String name, ResourceLocation texture) {
        return (ItemModelBuilder)this.singleTexture(name, RLUtils.createVanillaRL("item/handheld"), "layer0", texture);
    }

    protected static String getBlockName(Block block) {
        return block.getRegistryName().m_135815_();
    }

    protected static String getItemName(ItemLike item) {
        return item.m_5456_().getRegistryName().m_135815_();
    }
}

