/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.block.AbstractCrockPotCropBlock;
import com.sihenzhang.crockpot.block.AbstractCrockPotDoubleCropBlock;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.item.CrockPotItems;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.RegistryObject;

public class CrockPotLootTableProvider
extends LootTableProvider {
    public CrockPotLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(CrockPotBlockLoot::new, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
        map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)name, (LootTable)table));
    }

    public String m_6055_() {
        return "CrockPot LootTables";
    }

    public static class CrockPotBlockLoot
    extends BlockLoot {
        protected void addTables() {
            this.m_124288_((Block)CrockPotBlocks.BASIC_CROCK_POT.get());
            this.m_124288_((Block)CrockPotBlocks.ADVANCED_CROCK_POT.get());
            this.m_124288_((Block)CrockPotBlocks.ULTIMATE_CROCK_POT.get());
            this.m_124165_((Block)CrockPotBlocks.BIRDCAGE.get(), CrockPotBlockLoot.m_124137_((Block)((Block)CrockPotBlocks.BIRDCAGE.get())));
            this.m_124288_((Block)CrockPotBlocks.UNKNOWN_CROPS.get());
            this.m_124165_((Block)CrockPotBlocks.ASPARAGUS.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.ASPARAGUS.get(), (Item)CrockPotItems.ASPARAGUS.get(), (Item)CrockPotItems.ASPARAGUS_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.ASPARAGUS.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_124165_((Block)CrockPotBlocks.EGGPLANT.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.EGGPLANT.get(), (Item)CrockPotItems.EGGPLANT.get(), (Item)CrockPotItems.EGGPLANT_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.EGGPLANT.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_124165_((Block)CrockPotBlocks.GARLIC.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.GARLIC.get(), (Item)CrockPotItems.GARLIC.get(), (Item)CrockPotItems.GARLIC_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.GARLIC.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_124165_((Block)CrockPotBlocks.ONION.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.ONION.get(), (Item)CrockPotItems.ONION.get(), (Item)CrockPotItems.ONION_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.ONION.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_124165_((Block)CrockPotBlocks.PEPPER.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.PEPPER.get(), (Item)CrockPotItems.PEPPER.get(), (Item)CrockPotItems.PEPPER_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.PEPPER.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
            this.m_124165_((Block)CrockPotBlocks.TOMATO.get(), CrockPotBlockLoot.createCropDropsWithSeed((Block)CrockPotBlocks.TOMATO.get(), (Item)CrockPotItems.TOMATO.get(), (Item)CrockPotItems.TOMATO_SEEDS.get(), CrockPotBlockLoot.blockStatePropertyCondition((Block)CrockPotBlocks.TOMATO.get(), (Property<Integer>)AbstractCrockPotCropBlock.f_52244_, 7)));
        }

        protected static LootTable.Builder createCropDropsWithSeed(Block pCropBlock, Item pGrownCropItem, Item pSeedsItem, LootItemCondition.Builder pDropGrownCropCondition) {
            return (LootTable.Builder)CrockPotBlockLoot.m_124131_((ItemLike)pCropBlock, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pSeedsItem))).m_79161_(LootPool.m_79043_().m_6509_(pDropGrownCropCondition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)pGrownCropItem).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3)))));
        }

        protected static LootItemCondition.Builder blockStatePropertyCondition(Block pBlock, Property<Integer> pProperty, int pValue) {
            return LootItemBlockStatePropertyCondition.m_81769_((Block)pBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_(pProperty, pValue));
        }

        protected Iterable<Block> getKnownBlocks() {
            return CrockPotBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> !(block instanceof AbstractCrockPotDoubleCropBlock)).toList();
        }
    }
}

