/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.data.recipes;

import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.data.recipes.AbstractFinishedRecipe;
import com.sihenzhang.crockpot.data.recipes.AbstractRecipeBuilder;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.RangedItem;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class ParrotFeedingRecipeBuilder
extends AbstractRecipeBuilder {
    private final RangedItem result;
    private final Ingredient ingredient;

    public ParrotFeedingRecipeBuilder(ItemLike result, int resultMinimumCount, int resultMaximumCount, Ingredient ingredient) {
        this.result = new RangedItem(result.m_5456_(), resultMinimumCount, resultMaximumCount);
        this.ingredient = ingredient;
    }

    public static ParrotFeedingRecipeBuilder parrotFeeding(Ingredient ingredient, ItemLike result, int resultMinimumCount, int resultMaximumCount) {
        return new ParrotFeedingRecipeBuilder(result, resultMinimumCount, resultMaximumCount, ingredient);
    }

    public static ParrotFeedingRecipeBuilder parrotFeeding(Ingredient ingredient, ItemLike result, int resultCount) {
        return ParrotFeedingRecipeBuilder.parrotFeeding(ingredient, result, resultCount, resultCount);
    }

    public static ParrotFeedingRecipeBuilder parrotFeeding(Ingredient ingredient, ItemLike result) {
        return ParrotFeedingRecipeBuilder.parrotFeeding(ingredient, result, 1);
    }

    public Item m_142372_() {
        return this.result.item;
    }

    public void m_142700_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.ingredient, this.result));
    }

    public static class Result
    extends AbstractFinishedRecipe {
        private final Ingredient ingredient;
        private final RangedItem result;

        public Result(ResourceLocation id, Ingredient ingredient, RangedItem result) {
            super(id);
            this.ingredient = ingredient;
            this.result = result;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.add("result", this.result.toJson());
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CrockPotRecipes.PARROT_FEEDING_RECIPE_SERIALIZER.get();
        }
    }
}

