/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.integration.jei.JeiUtils;
import com.sihenzhang.crockpot.integration.jei.ModIntegrationJei;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FoodValuesCategory
implements IRecipeCategory<FoodValuesDefinition.FoodCategoryMatchedItems> {
    public static final RecipeType<FoodValuesDefinition.FoodCategoryMatchedItems> RECIPE_TYPE = RecipeType.create((String)"crockpot", (String)"food_values", FoodValuesDefinition.FoodCategoryMatchedItems.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FoodValuesCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RLUtils.createRL("textures/gui/jei/food_values.png"), 0, 0, 166, 117);
        this.icon = guiHelper.createDrawable(ModIntegrationJei.ICONS, 16, 0, 16, 16);
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends FoodValuesDefinition.FoodCategoryMatchedItems> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<FoodValuesDefinition.FoodCategoryMatchedItems> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return I18nUtils.createIntegrationComponent("jei", "food_values");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FoodValuesDefinition.FoodCategoryMatchedItems recipe, IFocusGroup focuses) {
        List<List<ItemStack>> pagedItemStacks = JeiUtils.getPagedItemStacks(recipe.items().stream().map(Item::m_7968_).toList(), focuses, RecipeIngredientRole.INPUT, 45);
        for (int i = 0; i < pagedItemStacks.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 3 + i % 9 * 18, 26 + i / 9 * 18).addItemStacks(pagedItemStacks.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 3).addItemStack(FoodCategory.getItemStack(recipe.category()));
    }
}

