/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.client.gui.screen.CrockPotScreen;
import com.sihenzhang.crockpot.integration.jei.CrockPotCookingRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.ExplosionCraftingRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.FoodValuesCategory;
import com.sihenzhang.crockpot.integration.jei.ParrotFeedingRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.ParrotLayingEggsRecipeCategory;
import com.sihenzhang.crockpot.integration.jei.PiglinBarteringRecipeCategory;
import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.FoodValuesDefinition;
import com.sihenzhang.crockpot.tag.CrockPotBlockTags;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ModIntegrationJei
implements IModPlugin {
    public static final String MOD_ID = "jei";
    public static final ResourceLocation ICONS = RLUtils.createRL("textures/gui/jei/icons.png");

    public ResourceLocation getPluginUid() {
        return RLUtils.createRL("crock_pot");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrockPotCookingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FoodValuesCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ExplosionCraftingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParrotLayingEggsRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParrotFeedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new PiglinBarteringRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(CrockPotCookingRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CrockPotRecipes.CROCK_POT_COOKING_RECIPE_TYPE.get()).stream().filter(r -> r.getResult().m_41720_() != CrockPotItems.AVAJ.get()).toList());
        registration.addRecipes(FoodValuesCategory.RECIPE_TYPE, FoodValuesDefinition.getFoodCategoryMatchedItemsList(recipeManager));
        registration.addRecipes(ExplosionCraftingRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_TYPE.get()));
        Map<Boolean, List<Item>> meatsGroupByMonster = FoodValuesDefinition.getMatchedItems(FoodCategory.MEAT, recipeManager).stream().collect(Collectors.groupingBy(item -> FoodValuesDefinition.getFoodValues(item, recipeManager).has(FoodCategory.MONSTER)));
        List<ParrotLayingEggsRecipeCategory.ParrotLayingEggsRecipeWrapper> parrotLayingEggsRecipes = List.of(new ParrotLayingEggsRecipeCategory.ParrotLayingEggsRecipeWrapper(Ingredient.m_43921_(meatsGroupByMonster.get(false).stream().map(Item::m_7968_)), 1, 1), new ParrotLayingEggsRecipeCategory.ParrotLayingEggsRecipeWrapper(Ingredient.m_43921_(meatsGroupByMonster.get(true).stream().map(Item::m_7968_)), 0, 1));
        registration.addRecipes(ParrotLayingEggsRecipeCategory.RECIPE_TYPE, parrotLayingEggsRecipes);
        registration.addRecipes(ParrotFeedingRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CrockPotRecipes.PARROT_FEEDING_RECIPE_TYPE.get()));
        registration.addRecipes(PiglinBarteringRecipeCategory.RECIPE_TYPE, recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)CrockPotRecipes.PIGLIN_BARTERING_RECIPE_TYPE.get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ForgeRegistries.BLOCKS.tags().getTag(CrockPotBlockTags.CROCK_POTS).stream().filter(CrockPotBlock.class::isInstance).map(CrockPotBlock.class::cast).map(block -> block.m_5456_().m_7968_()).forEach(pot -> registration.addRecipeCatalyst(pot, new RecipeType[]{CrockPotCookingRecipeCategory.RECIPE_TYPE}));
        registration.addRecipeCatalyst(((Item)CrockPotItems.BIRDCAGE.get()).m_7968_(), new RecipeType[]{ParrotLayingEggsRecipeCategory.RECIPE_TYPE, ParrotFeedingRecipeCategory.RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CrockPotScreen.class, 80, 43, 24, 18, new RecipeType[]{CrockPotCookingRecipeCategory.RECIPE_TYPE});
    }
}

