/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import vazkii.patchouli.api.IVariable;

public final class PatchouliUtils {
    public static IVariable ingredientVariable(Ingredient ingredient) {
        return IVariable.wrapList((Iterable)Arrays.stream(ingredient.m_43908_()).map(IVariable::from).collect(Collectors.toList()));
    }

    public static List<IVariable> pagedItemVariables(List<ItemStack> stacks, int size) {
        if (stacks.size() <= size) {
            return stacks.stream().map(IVariable::from).collect(Collectors.toList());
        }
        ArrayList<ArrayList<ItemStack>> pagedStacks = new ArrayList<ArrayList<ItemStack>>();
        for (int i = 0; i < size; ++i) {
            pagedStacks.add(new ArrayList<ItemStack>(List.of(stacks.get(i))));
        }
        int pages = (int)Math.ceil((double)stacks.size() / (double)size);
        for (int i = 1; i < pages; ++i) {
            for (int j = 0; j < size; ++j) {
                ((List)pagedStacks.get(j)).add(i * size + j < stacks.size() ? stacks.get(i * size + j) : ItemStack.f_41583_);
            }
        }
        return pagedStacks.stream().map(e -> IVariable.wrapList((Iterable)e.stream().map(IVariable::from).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public static <T extends Recipe<?>> T getRecipe(String name) {
        return (T)((Recipe)Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(new ResourceLocation(name)).orElse(null));
    }
}

