/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.patchouli;

import com.sihenzhang.crockpot.integration.patchouli.PatchouliUtils;
import com.sihenzhang.crockpot.recipe.ExplosionCraftingRecipe;
import com.sihenzhang.crockpot.util.StringUtils;
import net.minecraft.network.chat.TranslatableComponent;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorExplosionCrafting
implements IComponentProcessor {
    private ExplosionCraftingRecipe recipe;

    public void setup(IVariableProvider variables) {
        this.recipe = (ExplosionCraftingRecipe)PatchouliUtils.getRecipe(variables.get("recipe").asString());
    }

    public IVariable process(String key) {
        return switch (key) {
            case "input" -> PatchouliUtils.ingredientVariable(this.recipe.getIngredient());
            case "output" -> IVariable.from((Object)this.recipe.getResult());
            case "explosionTooltip" -> IVariable.from((Object)new TranslatableComponent("integration.crockpot.book.explosion_crafting.explosion"));
            case "isOnlyBlock" -> IVariable.wrap((Boolean)this.recipe.isOnlyBlock());
            case "onlyBlockTooltip" -> IVariable.from((Object)new TranslatableComponent("integration.crockpot.book.explosion_crafting.only_block"));
            case "rate" -> IVariable.wrap((String)StringUtils.format(1.0f - this.recipe.getLossRate(), "0.##%"));
            case "title" -> IVariable.from((Object)this.recipe.getResult().m_41786_());
            default -> null;
        };
    }
}

