/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.block.CrockPotBlocks;
import com.sihenzhang.crockpot.effect.CrockPotEffects;
import com.sihenzhang.crockpot.item.CollectedDustItem;
import com.sihenzhang.crockpot.item.CreativeMilkmadeHatItem;
import com.sihenzhang.crockpot.item.CrockPotBaseItem;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotSeedsItem;
import com.sihenzhang.crockpot.item.GnawsCoinItem;
import com.sihenzhang.crockpot.item.MilkmadeHatItem;
import com.sihenzhang.crockpot.item.NetherosiaItem;
import com.sihenzhang.crockpot.item.ParrotEggItem;
import com.sihenzhang.crockpot.item.food.CandyItem;
import com.sihenzhang.crockpot.item.food.CrockPotFoodItem;
import com.sihenzhang.crockpot.item.food.FlowerSaladItem;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCreamItem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class CrockPotItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crockpot");
    public static final RegistryObject<Item> BASIC_CROCK_POT = ITEMS.register("crock_pot_basic", () -> new CrockPotBlockItem((Block)CrockPotBlocks.BASIC_CROCK_POT.get()));
    public static final RegistryObject<Item> ADVANCED_CROCK_POT = ITEMS.register("crock_pot_advanced", () -> new CrockPotBlockItem((Block)CrockPotBlocks.ADVANCED_CROCK_POT.get()));
    public static final RegistryObject<Item> ULTIMATE_CROCK_POT = ITEMS.register("crock_pot_ultimate", () -> new CrockPotBlockItem((Block)CrockPotBlocks.ULTIMATE_CROCK_POT.get()));
    public static final RegistryObject<Item> UNKNOWN_SEEDS = ITEMS.register("unknown_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.UNKNOWN_CROPS.get()));
    public static final RegistryObject<Item> ASPARAGUS_SEEDS = ITEMS.register("asparagus_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.ASPARAGUS.get()));
    public static final RegistryObject<Item> ASPARAGUS = ITEMS.register("asparagus", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> CORN_SEEDS = ITEMS.register("corn_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.CORN.get()));
    public static final RegistryObject<Item> CORN = ITEMS.register("corn", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> POPCORN = ITEMS.register("popcorn", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.8f).duration(FoodUseDuration.FAST).hideEffects().build());
    public static final RegistryObject<Item> EGGPLANT_SEEDS = ITEMS.register("eggplant_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.EGGPLANT.get()));
    public static final RegistryObject<Item> EGGPLANT = ITEMS.register("eggplant", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> COOKED_EGGPLANT = ITEMS.register("cooked_eggplant", () -> CrockPotFoodItem.builder().nutrition(5).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> GARLIC_SEEDS = ITEMS.register("garlic_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.GARLIC.get()));
    public static final RegistryObject<Item> GARLIC = ITEMS.register("garlic", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> ONION_SEEDS = ITEMS.register("onion_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.ONION.get()));
    public static final RegistryObject<Item> ONION = ITEMS.register("onion", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> PEPPER_SEEDS = ITEMS.register("pepper_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.PEPPER.get()));
    public static final RegistryObject<Item> PEPPER = ITEMS.register("pepper", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).damage(CrockPotDamageSource.SPICY, 1.0f).hideEffects().build());
    public static final RegistryObject<Item> TOMATO_SEEDS = ITEMS.register("tomato_seeds", () -> new CrockPotSeedsItem((Block)CrockPotBlocks.TOMATO.get()));
    public static final RegistryObject<Item> TOMATO = ITEMS.register("tomato", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final Supplier<Set<Item>> SEEDS = Suppliers.memoize(() -> Set.of((Item)UNKNOWN_SEEDS.get(), (Item)ASPARAGUS_SEEDS.get(), (Item)CORN_SEEDS.get(), (Item)EGGPLANT_SEEDS.get(), (Item)GARLIC_SEEDS.get(), (Item)ONION_SEEDS.get(), (Item)PEPPER_SEEDS.get(), (Item)TOMATO_SEEDS.get()));
    public static final Supplier<Set<Item>> CROPS = Suppliers.memoize(() -> Set.of((Item)ASPARAGUS.get(), (Item)CORN.get(), (Item)EGGPLANT.get(), (Item)GARLIC.get(), (Item)ONION.get(), (Item)PEPPER.get(), (Item)TOMATO.get()));
    public static final Supplier<Set<Item>> COOKED_CROPS = Suppliers.memoize(() -> Set.of((Item)POPCORN.get(), (Item)COOKED_EGGPLANT.get()));
    public static final RegistryObject<Item> BIRDCAGE = ITEMS.register("birdcage", () -> new CrockPotBlockItem((Block)CrockPotBlocks.BIRDCAGE.get()));
    public static final Map<Integer, RegistryObject<Item>> PARROT_EGGS = ParrotEggItem.VARIANT_NAMES.stream().collect(Collectors.toMap(Pair::getFirst, pair -> ITEMS.register("parrot_egg_" + (String)pair.getSecond(), () -> new ParrotEggItem((Integer)pair.getFirst()))));
    public static final RegistryObject<Item> BLACKSTONE_DUST = ITEMS.register("blackstone_dust", CrockPotBaseItem::new);
    public static final RegistryObject<Item> COLLECTED_DUST = ITEMS.register("collected_dust", CollectedDustItem::new);
    public static final RegistryObject<Item> COOKED_EGG = ITEMS.register("cooked_egg", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).hideEffects().build());
    public static final RegistryObject<Item> FROG_LEGS = ITEMS.register("frog_legs", () -> CrockPotFoodItem.builder().nutrition(2).saturationMod(0.4f).meat().hideEffects().build());
    public static final RegistryObject<Item> COOKED_FROG_LEGS = ITEMS.register("cooked_frog_legs", () -> CrockPotFoodItem.builder().nutrition(5).saturationMod(0.7f).meat().hideEffects().build());
    public static final RegistryObject<Item> HOGLIN_NOSE = ITEMS.register("hoglin_nose", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.2f).meat().hideEffects().build());
    public static final RegistryObject<Item> COOKED_HOGLIN_NOSE = ITEMS.register("cooked_hoglin_nose", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.7f).meat().hideEffects().build());
    public static final RegistryObject<Item> MILK_BOTTLE = ITEMS.register("milk_bottle", () -> CrockPotFoodItem.builder().nutrition(0).saturationMod(0.0f).alwaysEat().drink().tooltip("milk_bottle", ChatFormatting.DARK_AQUA).hideEffects().build());
    public static final RegistryObject<Item> SYRUP = ITEMS.register("syrup", () -> CrockPotFoodItem.builder().nutrition(1).saturationMod(0.3f).drink().eatingSound(SoundEvents.f_11970_).hideEffects().build());
    public static final RegistryObject<Item> MILKMADE_HAT = ITEMS.register("milkmade_hat", MilkmadeHatItem::new);
    public static final RegistryObject<Item> CREATIVE_MILKMADE_HAT = ITEMS.register("creative_milkmade_hat", CreativeMilkmadeHatItem::new);
    public static final RegistryObject<Item> GNAWS_COIN = ITEMS.register("gnaws_coin", GnawsCoinItem::new);
    public static final RegistryObject<Item> ASPARAGUS_SOUP = ITEMS.register("asparagus_soup", () -> CrockPotFoodItem.builder().nutrition(4).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().removeEffect(MobEffects.f_19613_).removeEffect(MobEffects.f_19599_).removeEffect(MobEffects.f_19610_).removeEffect(MobEffects.f_19594_).build());
    public static final RegistryObject<Item> AVAJ = ITEMS.register("avaj", () -> CrockPotFoodItem.builder().nutrition(2).saturationMod(3.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 38800, 2).hide().rarity(Rarity.EPIC).build());
    public static final RegistryObject<Item> BACON_EGGS = ITEMS.register("bacon_eggs", () -> CrockPotFoodItem.builder().nutrition(12).saturationMod(0.8f).heal(4.0f).build());
    public static final RegistryObject<Item> BONE_SOUP = ITEMS.register("bone_soup", () -> CrockPotFoodItem.builder().nutrition(10).saturationMod(0.6f).effect(MobEffects.f_19617_, 2400, 1).build());
    public static final RegistryObject<Item> BONE_STEW = ITEMS.register("bone_stew", () -> CrockPotFoodItem.builder().nutrition(20).saturationMod(0.4f).duration(FoodUseDuration.SUPER_SLOW).effect(MobEffects.f_19601_, 1, 1).build());
    public static final RegistryObject<Item> BREAKFAST_SKILLET = ITEMS.register("breakfast_skillet", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.8f).build());
    public static final RegistryObject<Item> BUNNY_STEW = ITEMS.register("bunny_stew", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.8f).effect(MobEffects.f_19605_, 100).effect((Supplier<? extends MobEffect>)CrockPotEffects.WELL_FED, 2400).build());
    public static final RegistryObject<Item> CALIFORNIA_ROLL = ITEMS.register("california_roll", () -> CrockPotFoodItem.builder().nutrition(10).saturationMod(0.6f).heal(4.0f).effect(MobEffects.f_19617_, 1200).build());
    public static final RegistryObject<Item> CANDY = ITEMS.register("candy", CandyItem::new);
    public static final RegistryObject<Item> CEVICHE = ITEMS.register("ceviche", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.7f).alwaysEat().effect(MobEffects.f_19606_, 400, 1).effect(MobEffects.f_19617_, 400, 1).build());
    public static final RegistryObject<Item> FISH_STICKS = ITEMS.register("fish_sticks", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.7f).effect(MobEffects.f_19605_, 600).build());
    public static final RegistryObject<Item> FISH_TACOS = ITEMS.register("fish_tacos", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.9f).heal(2.0f).build());
    public static final RegistryObject<Item> FLOWER_SALAD = ITEMS.register("flower_salad", FlowerSaladItem::new);
    public static final RegistryObject<Item> FROGGLE_BUNWICH = ITEMS.register("froggle_bunwich", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.8f).build());
    public static final RegistryObject<Item> FRUIT_MEDLEY = ITEMS.register("fruit_medley", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.4f).effect(MobEffects.f_19596_, 3600).build());
    public static final RegistryObject<Item> GAZPACHO = ITEMS.register("gazpacho", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19607_, 12000).build());
    public static final RegistryObject<Item> GLOW_BERRY_MOUSSE = ITEMS.register("glow_berry_mousse", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.6f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19619_, 200).build());
    public static final RegistryObject<Item> HONEY_HAM = ITEMS.register("honey_ham", () -> CrockPotFoodItem.builder().nutrition(12).saturationMod(0.8f).effect(MobEffects.f_19605_, 400).effect(MobEffects.f_19617_, 1200, 1).heal(6.0f).build());
    public static final RegistryObject<Item> HONEY_NUGGETS = ITEMS.register("honey_nuggets", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.3f).effect(MobEffects.f_19605_, 200).effect(MobEffects.f_19617_, 1200).heal(4.0f).build());
    public static final RegistryObject<Item> HOT_CHILI = ITEMS.register("hot_chili", () -> CrockPotFoodItem.builder().nutrition(9).saturationMod(0.8f).effect(MobEffects.f_19600_, 1800).effect(MobEffects.f_19598_, 1800).build());
    public static final RegistryObject<Item> HOT_COCOA = ITEMS.register("hot_cocoa", () -> CrockPotFoodItem.builder().nutrition(2).saturationMod(0.1f).alwaysEat().drink().effect(MobEffects.f_19596_, 9600, 1).removeEffect(MobEffects.f_19597_).removeEffect(MobEffects.f_19599_).build());
    public static final RegistryObject<Item> ICE_CREAM = ITEMS.register("ice_cream", IceCreamItem::new);
    public static final RegistryObject<Item> ICED_TEA = ITEMS.register("iced_tea", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.1f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19603_, 6000, 1).build());
    public static final RegistryObject<Item> JAMMY_PRESERVES = ITEMS.register("jammy_preserves", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).build());
    public static final RegistryObject<Item> KABOBS = ITEMS.register("kabobs", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.7f).build());
    public static final RegistryObject<Item> MASHED_POTATOES = ITEMS.register("mashed_potatoes", () -> CrockPotFoodItem.builder().nutrition(9).saturationMod(0.6f).effect(MobEffects.f_19606_, 4800).build());
    public static final RegistryObject<Item> MEAT_BALLS = ITEMS.register("meat_balls", () -> CrockPotFoodItem.builder().nutrition(9).saturationMod(0.5f).build());
    public static final RegistryObject<Item> MONSTER_LASAGNA = ITEMS.register("monster_lasagna", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.2f).effect(MobEffects.f_19612_, 300).effect(MobEffects.f_19614_, 40).damage(CrockPotDamageSource.MONSTER_FOOD, 6.0f).build());
    public static final RegistryObject<Item> MONSTER_TARTARE = ITEMS.register("monster_tartare", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.7f).effect(MobEffects.f_19600_, 2400, 1).build());
    public static final RegistryObject<Item> MOQUECA = ITEMS.register("moqueca", () -> CrockPotFoodItem.builder().nutrition(14).saturationMod(0.7f).duration(FoodUseDuration.SLOW).effect(MobEffects.f_19616_, 1800, 2).heal(6.0f).build());
    public static final RegistryObject<Item> MUSHY_CAKE = ITEMS.register("mushy_cake", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect((Supplier<? extends MobEffect>)CrockPotEffects.WITHER_RESISTANCE, 1200).build());
    public static final RegistryObject<Item> NETHEROSIA = ITEMS.register("netherosia", NetherosiaItem::new);
    public static final RegistryObject<Item> PEPPER_POPPER = ITEMS.register("pepper_popper", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.8f).effect(MobEffects.f_19600_, 1200, 1).build());
    public static final RegistryObject<Item> PEROGIES = ITEMS.register("perogies", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.8f).heal(6.0f).build());
    public static final RegistryObject<Item> PLAIN_OMELETTE = ITEMS.register("plain_omelette", () -> CrockPotFoodItem.builder(7, 0.6f).build());
    public static final RegistryObject<Item> POTATO_SOUFFLE = ITEMS.register("potato_souffle", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.7f).effect(MobEffects.f_19606_, 1800, 1).build());
    public static final RegistryObject<Item> POTATO_TORNADO = ITEMS.register("potato_tornado", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(0.6f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build());
    public static final RegistryObject<Item> POW_CAKE = ITEMS.register("pow_cake", () -> CrockPotFoodItem.builder().nutrition(2).saturationMod(0.1f).alwaysEat().damage(CrockPotDamageSource.POW_CAKE, 1.0f).build());
    public static final RegistryObject<Item> PUMPKIN_COOKIE = ITEMS.register("pumpkin_cookie", () -> CrockPotFoodItem.builder().nutrition(10).saturationMod(0.7f).duration(FoodUseDuration.FAST).removeEffect(MobEffects.f_19612_).build());
    public static final RegistryObject<Item> RATATOUILLE = ITEMS.register("ratatouille", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.4f).duration(FoodUseDuration.FAST).build());
    public static final RegistryObject<Item> SALMON_SUSHI = ITEMS.register("salmon_sushi", () -> CrockPotFoodItem.builder().nutrition(5).saturationMod(0.8f).duration(FoodUseDuration.FAST).heal(1.0f).build());
    public static final RegistryObject<Item> SALSA = ITEMS.register("salsa", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.8f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19598_, 7200).build());
    public static final RegistryObject<Item> SCOTCH_EGG = ITEMS.register("scotch_egg", () -> CrockPotFoodItem.builder(8, 1.0f).build());
    public static final RegistryObject<Item> SEAFOOD_GUMBO = ITEMS.register("seafood_gumbo", () -> CrockPotFoodItem.builder().nutrition(9).saturationMod(0.7f).effect(MobEffects.f_19605_, 2400).build());
    public static final RegistryObject<Item> STUFFED_EGGPLANT = ITEMS.register("stuffed_eggplant", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.6f).duration(FoodUseDuration.FAST).heal(2.0f).build());
    public static final RegistryObject<Item> SURF_N_TURF = ITEMS.register("surf_n_turf", () -> CrockPotFoodItem.builder().nutrition(8).saturationMod(1.2f).alwaysEat().effect(MobEffects.f_19605_, 600, 1).heal(8.0f).build());
    public static final RegistryObject<Item> TAFFY = ITEMS.register("taffy", () -> CrockPotFoodItem.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).alwaysEat().effect(MobEffects.f_19621_, 9600).damage(CrockPotDamageSource.TAFFY, 1.0f).removeEffect(MobEffects.f_19614_).build());
    public static final RegistryObject<Item> TEA = ITEMS.register("tea", () -> CrockPotFoodItem.builder().nutrition(3).saturationMod(0.6f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19596_, 12000, 1).effect(MobEffects.f_19598_, 6000, 1).build());
    public static final RegistryObject<Item> TROPICAL_BOUILLABAISSE = ITEMS.register("tropical_bouillabaisse", () -> CrockPotFoodItem.builder().nutrition(7).saturationMod(0.6f).alwaysEat().effect((Supplier<? extends MobEffect>)CrockPotEffects.OCEAN_AFFINITY, 3000).build());
    public static final RegistryObject<Item> TURKEY_DINNER = ITEMS.register("turkey_dinner", () -> CrockPotFoodItem.builder().nutrition(12).saturationMod(0.8f).effect(MobEffects.f_19616_, 3600).build());
    public static final RegistryObject<Item> VEG_STINGER = ITEMS.register("veg_stinger", () -> CrockPotFoodItem.builder().nutrition(6).saturationMod(0.3f).duration(FoodUseDuration.FAST).alwaysEat().drink().effect(MobEffects.f_19611_, 12000).build());
    public static final RegistryObject<Item> WATERMELON_ICLE = ITEMS.register("watermelon_icle", () -> CrockPotFoodItem.builder().nutrition(5).saturationMod(0.4f).duration(FoodUseDuration.FAST).effect(MobEffects.f_19596_, 3600).effect(MobEffects.f_19603_, 3600).removeEffect(MobEffects.f_19597_).build());
    public static final RegistryObject<Item> WET_GOOP = ITEMS.register("wet_goop", () -> CrockPotFoodItem.builder().nutrition(0).saturationMod(0.0f).duration(FoodUseDuration.SUPER_SLOW).alwaysEat().effect(MobEffects.f_19604_, 200).tooltip("wet_goop", ChatFormatting.DARK_AQUA).build());
    public static final Supplier<List<Item>> FOODS_WITHOUT_AVAJ = Suppliers.memoize(() -> List.of((Item)ASPARAGUS_SOUP.get(), (Item)BACON_EGGS.get(), (Item)BONE_SOUP.get(), (Item)BONE_STEW.get(), (Item)BREAKFAST_SKILLET.get(), (Item)BUNNY_STEW.get(), (Item)CALIFORNIA_ROLL.get(), (Item)CANDY.get(), (Item)CEVICHE.get(), (Item)FISH_STICKS.get(), (Item)FISH_TACOS.get(), (Item)FLOWER_SALAD.get(), (Item)FROGGLE_BUNWICH.get(), (Item)FRUIT_MEDLEY.get(), (Item)GAZPACHO.get(), (Item)GLOW_BERRY_MOUSSE.get(), (Item)HONEY_HAM.get(), (Item)HONEY_NUGGETS.get(), (Item)HOT_CHILI.get(), (Item)HOT_COCOA.get(), (Item)ICE_CREAM.get(), (Item)ICED_TEA.get(), (Item)JAMMY_PRESERVES.get(), (Item)KABOBS.get(), (Item)MASHED_POTATOES.get(), (Item)MEAT_BALLS.get(), (Item)MONSTER_LASAGNA.get(), (Item)MONSTER_TARTARE.get(), (Item)MOQUECA.get(), (Item)MUSHY_CAKE.get(), (Item)PEPPER_POPPER.get(), (Item)PEROGIES.get(), (Item)PLAIN_OMELETTE.get(), (Item)POTATO_SOUFFLE.get(), (Item)POTATO_TORNADO.get(), (Item)POW_CAKE.get(), (Item)PUMPKIN_COOKIE.get(), (Item)RATATOUILLE.get(), (Item)SALMON_SUSHI.get(), (Item)SALSA.get(), (Item)SCOTCH_EGG.get(), (Item)SEAFOOD_GUMBO.get(), (Item)STUFFED_EGGPLANT.get(), (Item)SURF_N_TURF.get(), (Item)TAFFY.get(), (Item)TEA.get(), (Item)TROPICAL_BOUILLABAISSE.get(), (Item)TURKEY_DINNER.get(), (Item)VEG_STINGER.get(), (Item)WATERMELON_ICLE.get()));
    public static final Map<FoodCategory, RegistryObject<Item>> FOOD_CATEGORY_ITEMS = (Map)Util.m_137469_(new EnumMap(FoodCategory.class), map -> {
        for (FoodCategory category : FoodCategory.values()) {
            map.put(category, ITEMS.register("food_category_" + category.name().toLowerCase(), CrockPotBaseItem::new));
        }
    });

    private CrockPotItems() {
    }
}

