/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.item.food;

import com.mojang.datafixers.util.Pair;
import com.sihenzhang.crockpot.CrockPot;
import com.sihenzhang.crockpot.CrockPotConfigs;
import com.sihenzhang.crockpot.capability.FoodCounterCapabilityHandler;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.MathUtils;
import com.sihenzhang.crockpot.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CrockPotFoodItem
extends Item {
    private final int duration;
    private final boolean isDrink;
    private final SoundEvent eatingSound;
    private final int cooldown;
    private final float heal;
    private final Pair<DamageSource, Float> damage;
    private final List<MobEffect> removedEffects;
    private final List<Supplier<Component>> tooltips;
    private final boolean hideEffects;
    private final List<Supplier<Component>> effectTooltips;

    protected CrockPotFoodItem(CrockPotFoodItemBuilder builder) {
        super(builder.properties.m_41489_(builder.foodBuilder.m_38767_()));
        this.duration = builder.duration;
        this.isDrink = builder.isDrink;
        this.eatingSound = builder.eatingSound;
        this.cooldown = builder.cooldown;
        this.heal = builder.heal;
        this.damage = builder.damage;
        this.removedEffects = builder.removedEffects;
        this.tooltips = builder.tooltips;
        this.hideEffects = builder.hideEffects;
        this.effectTooltips = builder.effectTooltips;
    }

    public static CrockPotFoodItemBuilder builder() {
        return new CrockPotFoodItemBuilder();
    }

    public static CrockPotFoodItemBuilder builder(int nutrition, float saturationModifier) {
        return new CrockPotFoodItemBuilder(nutrition, saturationModifier);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.f_46443_) {
            if (this.damage != null && ((Float)this.damage.getSecond()).floatValue() > 0.0f) {
                pLivingEntity.m_6469_((DamageSource)this.damage.getFirst(), ((Float)this.damage.getSecond()).floatValue());
            }
            if (this.heal > 0.0f) {
                pLivingEntity.m_5634_(this.heal);
            }
            this.removedEffects.forEach(arg_0 -> ((LivingEntity)pLivingEntity).m_21195_(arg_0));
            if (this.cooldown > 0 && pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                player.m_36335_().m_41524_((Item)this, this.cooldown);
            }
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public int m_8105_(ItemStack pStack) {
        return this.duration;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        if (this.isDrink) {
            return UseAnim.DRINK;
        }
        return super.m_6164_(pStack);
    }

    public SoundEvent m_6061_() {
        if (this.eatingSound != null) {
            return this.eatingSound;
        }
        if (this.isDrink) {
            return SoundEvents.f_11911_;
        }
        return super.m_6061_();
    }

    public List<Pair<MobEffectInstance, Float>> getEffects() {
        FoodProperties foodProperties = this.m_41473_();
        return foodProperties == null ? List.of() : foodProperties.m_38749_().stream().map(p -> Pair.of((Object)((MobEffectInstance)p.getFirst()), (Object)((Float)p.getSecond()))).toList();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (!this.tooltips.isEmpty()) {
            this.tooltips.forEach(tip -> pTooltipComponents.add((Component)tip.get()));
        }
        if (pLevel != null && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.getCapability(FoodCounterCapabilityHandler.FOOD_COUNTER_CAPABILITY).ifPresent(foodCounter -> {
                if (!((Boolean)CrockPotConfigs.SHOW_FOOD_EFFECTS_TOOLTIP.get()).booleanValue() || this.hideEffects) {
                    return;
                }
                if (!foodCounter.hasEaten(this)) {
                    pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.not_eat").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    float hearts;
                    List<Pair<MobEffectInstance, Float>> effects = this.getEffects();
                    if (effects.isEmpty() && this.effectTooltips.isEmpty() && this.removedEffects.isEmpty() && this.heal <= 0.0f && (this.damage == null || ((Float)this.damage.getSecond()).floatValue() <= 0.0f)) {
                        pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.no_effect").m_130940_(ChatFormatting.GRAY));
                        return;
                    }
                    effects.forEach(p -> {
                        Float probability;
                        MobEffectInstance effect = (MobEffectInstance)p.getFirst();
                        TranslatableComponent tooltip = new TranslatableComponent(effect.m_19576_());
                        if (effect.m_19564_() > 0) {
                            tooltip = new TranslatableComponent("potion.withAmplifier", new Object[]{tooltip, new TranslatableComponent("potion.potency." + effect.m_19564_())});
                        }
                        if (effect.m_19557_() > 20) {
                            tooltip = new TranslatableComponent("potion.withDuration", new Object[]{tooltip, MobEffectUtil.m_19581_((MobEffectInstance)effect, (float)1.0f)});
                        }
                        if ((probability = (Float)p.getSecond()).floatValue() < 1.0f) {
                            tooltip = I18nUtils.createTooltipComponent("effect.with_probability", StringUtils.format(probability.floatValue(), "0.##%"), tooltip);
                        }
                        pTooltipComponents.add((Component)tooltip.m_130940_(effect.m_19544_().m_19483_().m_19497_()));
                    });
                    if (!this.effectTooltips.isEmpty() || !this.removedEffects.isEmpty() || this.heal > 0.0f || this.damage != null && ((Float)this.damage.getSecond()).floatValue() > 0.0f) {
                        pTooltipComponents.add(TextComponent.f_131282_);
                        pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.when_" + (this.isDrink ? "drunk" : "eaten")).m_130940_(ChatFormatting.DARK_PURPLE));
                    }
                    this.effectTooltips.forEach(tip -> pTooltipComponents.add((Component)tip.get()));
                    this.removedEffects.forEach(e -> pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.remove", new TranslatableComponent(e.m_19481_())).m_130940_(ChatFormatting.GOLD)));
                    if (this.heal > 0.0f) {
                        hearts = this.heal / 2.0f;
                        pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.heal." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), StringUtils.format(hearts, "0.#")).m_130940_(ChatFormatting.BLUE));
                    }
                    if (this.damage != null && ((Float)this.damage.getSecond()).floatValue() > 0.0f) {
                        hearts = ((Float)this.damage.getSecond()).floatValue() / 2.0f;
                        pTooltipComponents.add((Component)I18nUtils.createTooltipComponent("effect.damage." + (MathUtils.fuzzyEquals(hearts, 1.0f) ? "single" : "multiple"), StringUtils.format(hearts, "0.#")).m_130940_(ChatFormatting.RED));
                    }
                }
            });
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public static class CrockPotFoodItemBuilder {
        private Item.Properties properties = new Item.Properties().m_41491_(CrockPot.ITEM_GROUP);
        private int maxStackSize = 64;
        private Rarity rarity = Rarity.COMMON;
        private FoodProperties.Builder foodBuilder = new FoodProperties.Builder();
        private int duration;
        private boolean isDrink;
        private SoundEvent eatingSound;
        private int cooldown;
        private float heal;
        private Pair<DamageSource, Float> damage;
        private final List<MobEffect> removedEffects;
        private final List<Supplier<Component>> tooltips;
        private boolean hideEffects;
        private final List<Supplier<Component>> effectTooltips;

        public CrockPotFoodItemBuilder() {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<MobEffect>();
            this.tooltips = new ArrayList<Supplier<Component>>();
            this.effectTooltips = new ArrayList<Supplier<Component>>();
        }

        public CrockPotFoodItemBuilder(int nutrition, float saturationModifier) {
            this.duration = FoodUseDuration.NORMAL.val;
            this.removedEffects = new ArrayList<MobEffect>();
            this.tooltips = new ArrayList<Supplier<Component>>();
            this.effectTooltips = new ArrayList<Supplier<Component>>();
            this.foodBuilder = this.foodBuilder.m_38760_(nutrition).m_38758_(saturationModifier);
        }

        public CrockPotFoodItemBuilder nutrition(int nutrition) {
            this.foodBuilder = this.foodBuilder.m_38760_(nutrition);
            return this;
        }

        public CrockPotFoodItemBuilder saturationMod(float saturationModifier) {
            this.foodBuilder = this.foodBuilder.m_38758_(saturationModifier);
            return this;
        }

        public CrockPotFoodItemBuilder meat() {
            this.foodBuilder = this.foodBuilder.m_38757_();
            return this;
        }

        public CrockPotFoodItemBuilder alwaysEat() {
            this.foodBuilder = this.foodBuilder.m_38765_();
            return this;
        }

        public CrockPotFoodItemBuilder duration(FoodUseDuration duration) {
            this.duration = duration.val;
            return this;
        }

        public CrockPotFoodItemBuilder effect(Supplier<MobEffectInstance> effect, float probability) {
            this.foodBuilder = this.foodBuilder.effect(effect, probability);
            return this;
        }

        public CrockPotFoodItemBuilder effect(Supplier<MobEffectInstance> effect) {
            this.foodBuilder = this.foodBuilder.effect(effect, 1.0f);
            return this;
        }

        public CrockPotFoodItemBuilder effect(MobEffect effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration, amplifier), probability);
        }

        public CrockPotFoodItemBuilder effect(MobEffect effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public CrockPotFoodItemBuilder effect(MobEffect effect, int duration, float probability) {
            return this.effect(() -> new MobEffectInstance(effect, duration), probability);
        }

        public CrockPotFoodItemBuilder effect(MobEffect effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public CrockPotFoodItemBuilder effect(Supplier<? extends MobEffect> effect, int duration, int amplifier, float probability) {
            return this.effect(() -> new MobEffectInstance((MobEffect)effect.get(), duration, amplifier), probability);
        }

        public CrockPotFoodItemBuilder effect(Supplier<? extends MobEffect> effect, int duration, int amplifier) {
            return this.effect(effect, duration, amplifier, 1.0f);
        }

        public CrockPotFoodItemBuilder effect(Supplier<? extends MobEffect> effect, int duration, float probability) {
            return this.effect(() -> new MobEffectInstance((MobEffect)effect.get(), duration), probability);
        }

        public CrockPotFoodItemBuilder effect(Supplier<? extends MobEffect> effect, int duration) {
            return this.effect(effect, duration, 1.0f);
        }

        public CrockPotFoodItemBuilder drink() {
            this.isDrink = true;
            return this;
        }

        public CrockPotFoodItemBuilder eatingSound(SoundEvent eatingSound) {
            this.eatingSound = eatingSound;
            return this;
        }

        public CrockPotFoodItemBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public CrockPotFoodItemBuilder heal(float heal) {
            this.heal = heal;
            return this;
        }

        public CrockPotFoodItemBuilder damage(DamageSource damageSource, float damageAmount) {
            this.damage = Pair.of((Object)damageSource, (Object)Float.valueOf(damageAmount));
            return this;
        }

        public CrockPotFoodItemBuilder removeEffect(MobEffect effect) {
            this.removedEffects.add(effect);
            return this;
        }

        public CrockPotFoodItemBuilder tooltip(String key) {
            this.tooltips.add(() -> I18nUtils.createTooltipComponent(key));
            return this;
        }

        public CrockPotFoodItemBuilder tooltip(String key, ChatFormatting ... formats) {
            this.tooltips.add(() -> I18nUtils.createTooltipComponent(key).m_130944_(formats));
            return this;
        }

        public CrockPotFoodItemBuilder hideEffects() {
            this.hideEffects = true;
            return this;
        }

        public CrockPotFoodItemBuilder effectTooltip(Component tooltip) {
            this.effectTooltips.add(() -> tooltip);
            return this;
        }

        public CrockPotFoodItemBuilder effectTooltip(String key, ChatFormatting ... formats) {
            return this.effectTooltip((Component)I18nUtils.createTooltipComponent("effect." + key).m_130944_(formats));
        }

        public CrockPotFoodItemBuilder effectTooltip(String key) {
            return this.effectTooltip((Component)I18nUtils.createTooltipComponent("effect." + key));
        }

        public CrockPotFoodItemBuilder hide() {
            this.properties = new Item.Properties();
            if (this.maxStackSize != 64) {
                this.properties = this.properties.m_41487_(this.maxStackSize);
            }
            if (this.rarity != Rarity.COMMON) {
                this.properties = this.properties.m_41497_(this.rarity);
            }
            return this;
        }

        public CrockPotFoodItemBuilder stacksTo(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            this.properties = this.properties.m_41487_(this.maxStackSize);
            return this;
        }

        public CrockPotFoodItemBuilder rarity(Rarity rarity) {
            this.rarity = rarity;
            this.properties = this.properties.m_41497_(this.rarity);
            return this;
        }

        public CrockPotFoodItem build() {
            return new CrockPotFoodItem(this);
        }
    }
}

