/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.util.JsonUtils;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ExplosionCraftingRecipe
extends AbstractCrockPotRecipe {
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float lossRate;
    private final boolean onlyBlock;

    public ExplosionCraftingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float lossRate, boolean onlyBlock) {
        super(id);
        ItemStack[] items;
        Ingredient dummyInput = ingredient;
        boolean inputHasBlockItem = false;
        if (onlyBlock && (inputHasBlockItem = Arrays.stream(items = ingredient.m_43908_()).anyMatch(stack -> stack.m_41720_() instanceof BlockItem))) {
            dummyInput = Ingredient.m_43921_(Arrays.stream(items).filter(stack -> stack.m_41720_() instanceof BlockItem));
        }
        this.ingredient = dummyInput;
        this.result = result;
        this.lossRate = Mth.m_14036_((float)lossRate, (float)0.0f, (float)1.0f);
        this.onlyBlock = inputHasBlockItem;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public float getLossRate() {
        return this.lossRate;
    }

    public boolean isOnlyBlock() {
        return this.onlyBlock;
    }

    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    @Nullable
    public static ExplosionCraftingRecipe getRecipeFor(ItemStack stack, RecipeManager recipeManager) {
        return stack.m_41619_() ? null : (ExplosionCraftingRecipe)recipeManager.m_44013_((RecipeType)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_TYPE.get()).stream().filter(r -> !r.isOnlyBlock() && r.matches(stack)).findFirst().orElse(null);
    }

    @Nullable
    public static ExplosionCraftingRecipe getRecipeFor(BlockState state, RecipeManager recipeManager) {
        if (state == null) {
            return null;
        }
        Block block = state.m_60734_();
        return block == Blocks.f_50016_ || !(block.m_5456_() instanceof BlockItem) ? null : (ExplosionCraftingRecipe)recipeManager.m_44013_((RecipeType)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_TYPE.get()).stream().filter(r -> r.matches(block.m_5456_().m_7968_())).findFirst().orElse(null);
    }

    public ItemStack assemble(Random rand) {
        if (MathUtils.fuzzyIsZero(this.lossRate)) {
            return this.result.m_41777_();
        }
        if (this.result.m_41613_() == 1) {
            return rand.nextFloat() >= this.lossRate ? this.result.m_41777_() : ItemStack.f_41583_;
        }
        int count = (int)rand.doubles(this.result.m_41613_()).filter(d -> d >= (double)this.lossRate).count();
        if (count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack output = this.result.m_41777_();
        output.m_41764_(count);
        return output;
    }

    @Override
    public ItemStack m_8043_() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.EXPLOSION_CRAFTING_RECIPE_TYPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ExplosionCraftingRecipe> {
        public ExplosionCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(serializedRecipe, "ingredient");
            ItemStack result = JsonUtils.getAsItemStack(serializedRecipe, "result");
            float lossRate = Mth.m_14036_((float)GsonHelper.m_13820_((JsonObject)serializedRecipe, (String)"lossrate", (float)0.0f), (float)0.0f, (float)1.0f);
            boolean onlyBlock = GsonHelper.m_13855_((JsonObject)serializedRecipe, (String)"onlyblock", (boolean)false);
            return new ExplosionCraftingRecipe(recipeId, ingredient, result, lossRate, onlyBlock);
        }

        @Nullable
        public ExplosionCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            float lossRate = buffer.readFloat();
            boolean onlyBlock = buffer.readBoolean();
            return new ExplosionCraftingRecipe(recipeId, ingredient, result, lossRate, onlyBlock);
        }

        public void toNetwork(FriendlyByteBuf buffer, ExplosionCraftingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            buffer.m_130055_(recipe.getResult());
            buffer.writeFloat(recipe.getLossRate());
            buffer.writeBoolean(recipe.isOnlyBlock());
        }
    }
}

