/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.base.FoodValues;
import com.sihenzhang.crockpot.recipe.AbstractCrockPotRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.util.MathUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FoodValuesDefinition
extends AbstractCrockPotRecipe {
    private final Set<ResourceLocation> names;
    private final FoodValues foodValues;
    private final boolean isTag;

    public FoodValuesDefinition(ResourceLocation id, Set<ResourceLocation> names, FoodValues foodValues, boolean isTag) {
        super(id);
        this.names = ImmutableSet.copyOf(names);
        this.foodValues = foodValues;
        this.isTag = isTag;
    }

    public Set<ResourceLocation> getNames() {
        return this.names;
    }

    public FoodValues getFoodValues() {
        return this.foodValues;
    }

    public boolean isTag() {
        return this.isTag;
    }

    @Nonnull
    public static FoodValues getFoodValues(Item item, RecipeManager recipeManager) {
        if (item == null || item == Items.f_41852_) {
            return FoodValues.create();
        }
        List allDefs = recipeManager.m_44013_((RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get());
        Optional<FoodValuesDefinition> itemDef = allDefs.stream().filter(def -> !def.isTag() && def.getNames().stream().anyMatch(name -> name.equals((Object)item.getRegistryName()))).findFirst();
        if (itemDef.isPresent()) {
            return itemDef.get().getFoodValues();
        }
        FoodValues foodValues = FoodValues.create();
        long maxCount = -1L;
        HashMap tagDefs = new HashMap();
        allDefs.stream().filter(FoodValuesDefinition::isTag).forEach(tagDef -> tagDef.getNames().forEach(name -> tagDefs.put(name, tagDef.getFoodValues())));
        for (ResourceLocation tag : item.m_204114_().m_203616_().map(TagKey::f_203868_).toList()) {
            long count;
            if (!tagDefs.containsKey(tag) || (count = tag.toString().chars().filter(c -> c == 47).count()) < maxCount) continue;
            if (count > maxCount) {
                maxCount = count;
                foodValues.clear();
            }
            ((FoodValues)tagDefs.get(tag)).entrySet().forEach(entry -> foodValues.put((FoodCategory)((Object)((Object)entry.getKey())), Math.max(foodValues.get((FoodCategory)((Object)((Object)entry.getKey()))), ((Float)entry.getValue()).floatValue())));
        }
        return foodValues;
    }

    @Nonnull
    public static Set<Item> getMatchedItems(FoodCategory category, RecipeManager recipeManager) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((i1, i2) -> {
            float v2;
            ResourceLocation r1 = i1.getRegistryName();
            ResourceLocation r2 = i2.getRegistryName();
            String n1 = Objects.requireNonNull(r1).m_135827_();
            String n2 = Objects.requireNonNull(r2).m_135827_();
            float v1 = FoodValuesDefinition.getFoodValues(i1, recipeManager).get(category);
            if (MathUtils.fuzzyEquals(v1, v2 = FoodValuesDefinition.getFoodValues(i2, recipeManager).get(category))) {
                if ("minecraft".equals(n1)) {
                    return "minecraft".equals(n2) ? r1.compareTo(r2) : -1;
                }
                if ("minecraft".equals(n2)) {
                    return 1;
                }
                if ("crockpot".equals(n1)) {
                    return "crockpot".equals(n2) ? r1.compareTo(r2) : -1;
                }
                if ("crockpot".equals(n2)) {
                    return 1;
                }
                return r1.compareTo(r2);
            }
            return Float.compare(v1, v2);
        });
        List allDefs = recipeManager.m_44013_((RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get());
        allDefs.stream().filter(def -> !def.isTag()).forEach(itemDef -> itemDef.getNames().forEach(name -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(name);
            if (item != null && item != Items.f_41852_ && itemDef.getFoodValues().has(category)) {
                builder.add((Object)item);
            }
        }));
        allDefs.stream().filter(FoodValuesDefinition::isTag).forEach(tagDef -> tagDef.getNames().forEach(name -> {
            TagKey tag = ItemTags.create((ResourceLocation)name);
            if (ForgeRegistries.ITEMS.tags().isKnownTagName(tag) && tagDef.getFoodValues().has(category)) {
                Ingredient.TagValue tagList = new Ingredient.TagValue(tag);
                tagList.m_6223_().forEach(stack -> {
                    Item item = stack.m_41720_();
                    if (FoodValuesDefinition.getFoodValues(item, recipeManager).has(category)) {
                        builder.add((Object)item);
                    }
                });
            }
        }));
        return builder.build();
    }

    @Nonnull
    public static List<FoodCategoryMatchedItems> getFoodCategoryMatchedItemsList(RecipeManager recipeManager) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FoodCategory category : FoodCategory.values()) {
            builder.add((Object)new FoodCategoryMatchedItems(category, FoodValuesDefinition.getMatchedItems(category, recipeManager)));
        }
        return builder.build();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.FOOD_VALUES_RECIPE_SERIALIZER.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.FOOD_VALUES_RECIPE_TYPE.get();
    }

    public record FoodCategoryMatchedItems(FoodCategory category, Set<Item> items) {
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<FoodValuesDefinition> {
        public FoodValuesDefinition fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            FoodValues foodValues = FoodValues.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"values"));
            if (serializedRecipe.has("items") && serializedRecipe.has("tags")) {
                throw new JsonParseException("A food value definition entry needs either tags or items, not both");
            }
            if (serializedRecipe.has("items") || serializedRecipe.has("tags")) {
                HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
                boolean isTag = serializedRecipe.has("tags");
                GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)(isTag ? "tags" : "items")).forEach(name -> names.add(new ResourceLocation(GsonHelper.m_13805_((JsonElement)name, (String)(isTag ? "tag" : "item")))));
                return new FoodValuesDefinition(recipeId, names, foodValues, isTag);
            }
            throw new JsonParseException("A food value definition entry needs either tags or items");
        }

        @Nullable
        public FoodValuesDefinition fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            boolean isTag = buffer.readBoolean();
            HashSet<ResourceLocation> names = new HashSet<ResourceLocation>();
            int length = buffer.m_130242_();
            for (int i = 0; i < length; ++i) {
                names.add(buffer.m_130281_());
            }
            FoodValues foodValues = FoodValues.fromNetwork(buffer);
            return new FoodValuesDefinition(recipeId, names, foodValues, isTag);
        }

        public void toNetwork(FriendlyByteBuf buffer, FoodValuesDefinition recipe) {
            buffer.writeBoolean(recipe.isTag());
            buffer.m_130130_(recipe.getNames().size());
            recipe.getNames().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
            recipe.getFoodValues().toNetwork(buffer);
        }
    }
}

