/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.item.CrockPotItems;
import com.sihenzhang.crockpot.recipe.AbstractRecipe;
import com.sihenzhang.crockpot.recipe.CrockPotRecipes;
import com.sihenzhang.crockpot.recipe.RangedItem;
import com.sihenzhang.crockpot.util.JsonUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ParrotFeedingRecipe
extends AbstractRecipe {
    private static final Random RANDOM = new Random();
    private final Ingredient ingredient;
    private final RangedItem result;

    public ParrotFeedingRecipe(ResourceLocation id, Ingredient ingredient, RangedItem result) {
        super(id);
        this.ingredient = ingredient;
        this.result = result;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    public ItemStack m_5874_(Container pContainer) {
        return this.result.getInstance(RANDOM);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public RangedItem getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return (NonNullList)Util.m_137469_((Object)NonNullList.m_122779_(), list -> list.add((Object)this.ingredient));
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.result.item, this.result.max);
    }

    public ItemStack m_8042_() {
        return ((Item)CrockPotItems.BIRDCAGE.get()).m_7968_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CrockPotRecipes.PARROT_FEEDING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CrockPotRecipes.PARROT_FEEDING_RECIPE_TYPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ParrotFeedingRecipe> {
        public ParrotFeedingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient ingredient = JsonUtils.getAsIngredient(pSerializedRecipe, "ingredient");
            RangedItem result = RangedItem.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"));
            return new ParrotFeedingRecipe(pRecipeId, ingredient, result);
        }

        @Nullable
        public ParrotFeedingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            RangedItem result = RangedItem.fromNetwork(pBuffer);
            return new ParrotFeedingRecipe(pRecipeId, ingredient, result);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ParrotFeedingRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pRecipe.result.toNetwork(pBuffer);
        }
    }
}

