/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class RequirementCategoryMaxExclusive
implements IRequirement {
    private final FoodCategory category;
    private final float max;

    public RequirementCategoryMaxExclusive(FoodCategory category, float max) {
        this.category = category;
        this.max = max;
    }

    public FoodCategory getCategory() {
        return this.category;
    }

    public float getMax() {
        return this.max;
    }

    @Override
    public boolean test(CrockPotCookingRecipeInput recipeInput) {
        return recipeInput.mergedFoodValues().get(this.category) < this.max;
    }

    public static RequirementCategoryMaxExclusive fromJson(JsonObject object) {
        return new RequirementCategoryMaxExclusive(JsonUtils.getAsEnum(object, "category", FoodCategory.class), GsonHelper.m_13915_((JsonObject)object, (String)"max"));
    }

    @Override
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", RequirementType.CATEGORY_MAX.name());
        obj.addProperty("category", this.category.name());
        obj.addProperty("max", (Number)Float.valueOf(this.max));
        return obj;
    }

    public static RequirementCategoryMaxExclusive fromNetwork(FriendlyByteBuf buffer) {
        return new RequirementCategoryMaxExclusive((FoodCategory)buffer.m_130066_(FoodCategory.class), buffer.readFloat());
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)RequirementType.CATEGORY_MAX_EXCLUSIVE);
        buffer.m_130068_((Enum)this.category);
        buffer.writeFloat(this.max);
    }
}

