/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.base.FoodCategory;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class RequirementCategoryMin
implements IRequirement {
    private final FoodCategory category;
    private final float min;

    public RequirementCategoryMin(FoodCategory category, float min) {
        this.category = category;
        this.min = min;
    }

    public FoodCategory getCategory() {
        return this.category;
    }

    public float getMin() {
        return this.min;
    }

    @Override
    public boolean test(CrockPotCookingRecipeInput recipeInput) {
        return recipeInput.mergedFoodValues().get(this.category) >= this.min;
    }

    public static RequirementCategoryMin fromJson(JsonObject object) {
        return new RequirementCategoryMin(JsonUtils.getAsEnum(object, "category", FoodCategory.class), GsonHelper.m_13915_((JsonObject)object, (String)"min"));
    }

    @Override
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", RequirementType.CATEGORY_MIN.name());
        obj.addProperty("category", this.category.name());
        obj.addProperty("min", (Number)Float.valueOf(this.min));
        return obj;
    }

    public static RequirementCategoryMin fromNetwork(FriendlyByteBuf buffer) {
        return new RequirementCategoryMin((FoodCategory)buffer.m_130066_(FoodCategory.class), buffer.readFloat());
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)RequirementType.CATEGORY_MIN);
        buffer.m_130068_((Enum)this.category);
        buffer.writeFloat(this.min);
    }
}

