/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.recipe.cooking.requirement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipeInput;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.recipe.cooking.requirement.RequirementType;
import com.sihenzhang.crockpot.util.JsonUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;

public class RequirementMustContainIngredientLessThan
implements IRequirement {
    private final Ingredient ingredient;
    private final int quantity;

    public RequirementMustContainIngredientLessThan(Ingredient ingredient, int quantity) {
        this.ingredient = ingredient;
        this.quantity = quantity;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean test(CrockPotCookingRecipeInput recipeInput) {
        return recipeInput.stacks().stream().filter(this.ingredient).count() <= (long)this.quantity;
    }

    public static RequirementMustContainIngredientLessThan fromJson(JsonObject object) {
        return new RequirementMustContainIngredientLessThan(JsonUtils.getAsIngredient(object, "ingredient", true), GsonHelper.m_13927_((JsonObject)object, (String)"quantity"));
    }

    @Override
    public JsonElement toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", RequirementType.MUST_CONTAIN_INGREDIENT_LESS_THAN.name());
        obj.add("ingredient", this.ingredient.m_43942_());
        obj.addProperty("quantity", (Number)this.quantity);
        return obj;
    }

    public static RequirementMustContainIngredientLessThan fromNetwork(FriendlyByteBuf buffer) {
        return new RequirementMustContainIngredientLessThan(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readByte());
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)RequirementType.MUST_CONTAIN_INGREDIENT_LESS_THAN);
        this.ingredient.m_43923_(buffer);
        buffer.writeByte(this.quantity);
    }
}

