/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LootTableUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void addEntryToLootTable(LootTable lootTable, String poolName, LootPoolEntryContainer ... lootEntries) {
        LootPool pool = Objects.requireNonNull(lootTable.getPool(poolName));
        try {
            for (LootPoolEntryContainer lootEntry : lootEntries) {
                LootTableUtils.addEntryToLootPool(pool, lootEntry);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Error occurred when attempting to add a new entry to \"" + lootTable.getLootTableId() + "\" loot table", (Throwable)e);
        }
    }

    public static void addEntryToLootTable(LootTable lootTable, LootPoolEntryContainer ... lootEntries) {
        LootTableUtils.addEntryToLootTable(lootTable, "main", lootEntries);
    }

    private static void addEntryToLootPool(LootPool lootPool, LootPoolEntryContainer lootEntry) throws IllegalAccessException {
        Field entries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"f_79023_");
        LootPoolEntryContainer[] lootPoolEntriesArray = (LootPoolEntryContainer[])entries.get(lootPool);
        ArrayList<LootPoolEntryContainer> newLootEntries = new ArrayList<LootPoolEntryContainer>(List.of(lootPoolEntriesArray));
        if (newLootEntries.stream().anyMatch(e -> e == lootEntry)) {
            throw new RuntimeException("Attempted to add a duplicate entry to pool: " + lootEntry);
        }
        newLootEntries.add(lootEntry);
        LootPoolEntryContainer[] newLootEntriesArray = newLootEntries.toArray(new LootPoolEntryContainer[0]);
        entries.set(lootPool, newLootEntriesArray);
    }
}

