/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.util;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.Reader;
import java.io.StringReader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;

public final class NbtUtils {
    public static JsonElement convertToJson(Tag nbt) {
        JsonReader reader = new JsonReader((Reader)new StringReader(nbt.toString()));
        reader.setLenient(true);
        return JsonParser.parseReader((JsonReader)reader);
    }

    public static Tag writeIngredient(Ingredient ingredient) throws CommandSyntaxException {
        JsonElement json = ingredient.m_43942_();
        if (json.isJsonObject()) {
            return TagParser.m_129359_((String)json.toString());
        }
        ListTag list = new ListTag();
        for (JsonElement e : json.getAsJsonArray()) {
            list.add((Object)TagParser.m_129359_((String)e.toString()));
        }
        return list;
    }

    public static Ingredient readIngredient(Tag nbt) {
        Preconditions.checkArgument((nbt != null ? 1 : 0) != 0, (Object)"Ingredient cannot be null");
        if (nbt.m_6458_() == ListTag.f_128714_) {
            ListTag list = (ListTag)nbt;
            ListTag result = new ListTag();
            for (Tag e : list) {
                Preconditions.checkArgument((e.m_6458_() == CompoundTag.f_128326_ ? 1 : 0) != 0, (Object)"Expcted ingredient to be a object or array of objects");
                CompoundTag compound = (CompoundTag)e;
                if (compound.m_128441_("item") && compound.m_128441_("tag")) {
                    throw new IllegalArgumentException("An ingredient entry is either a tag or an item, not both");
                }
                if (compound.m_128441_("item")) {
                    name = compound.m_128461_("item");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
                    if (item == null || item == Items.f_41852_) {
                        continue;
                    }
                } else if (compound.m_128441_("tag")) {
                    name = compound.m_128461_("tag");
                    TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(name));
                    if (!ForgeRegistries.ITEMS.tags().isKnownTagName(tag)) {
                        continue;
                    }
                } else {
                    throw new IllegalArgumentException("An ingredient entry needs either a tag or an item");
                }
                result.add((Object)e);
            }
            return Ingredient.m_43917_((JsonElement)NbtUtils.convertToJson((Tag)result));
        }
        return Ingredient.m_43917_((JsonElement)NbtUtils.convertToJson(nbt));
    }

    public static ItemStack setLoreString(ItemStack stack, String string) {
        CompoundTag displayTag = new CompoundTag();
        CompoundTag loreTag = new CompoundTag();
        ListTag loreListTag = new ListTag();
        loreListTag.add((Object)StringTag.m_129297_((String)("{\"text\":\"" + string + "\"}")));
        loreTag.m_128365_("Lore", (Tag)loreListTag);
        displayTag.m_128365_("display", (Tag)loreTag);
        stack.m_41751_(displayTag);
        return stack;
    }
}

