/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot;

import com.sihenzhang.crockpot.CrockPotConfig;
import com.sihenzhang.crockpot.CrockPotRegistry;
import com.sihenzhang.crockpot.base.FoodCategoryManager;
import com.sihenzhang.crockpot.client.gui.screen.CrockPotScreen;
import com.sihenzhang.crockpot.integration.ModIntegrationTheOneProbe;
import com.sihenzhang.crockpot.integration.patchouli.ModIntegrationPatchouli;
import com.sihenzhang.crockpot.loot.CrockPotSeedsDropModifier;
import com.sihenzhang.crockpot.network.NetworkManager;
import com.sihenzhang.crockpot.network.PacketSyncCrockPotFoodCategory;
import com.sihenzhang.crockpot.recipe.RecipeManager;
import net.minecraft.block.ComposterBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="crockpot")
public final class CrockPot {
    public static final String MOD_ID = "crockpot";
    public static final ItemGroup ITEM_GROUP = new ItemGroup("crockpot"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)CrockPotRegistry.crockPotBasicBlockItem.get());
        }
    };
    public static final FoodCategoryManager FOOD_CATEGORY_MANAGER = new FoodCategoryManager();
    public static final RecipeManager RECIPE_MANAGER = new RecipeManager();

    public CrockPot() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CrockPotConfig.COMMON_CONFIG);
        CrockPotRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CrockPotRegistry.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        CrockPotRegistry.TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CrockPotRegistry.CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onAnimalAppear);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::sendIMCMessage);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(GlobalLootModifierSerializer.class, this::registerModifierSerializers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> NetworkManager.registerPackets());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addComposterRecipes);
    }

    public void sendIMCMessage(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", ModIntegrationTheOneProbe::new);
        }
    }

    public void onServerStarting(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager manager = event.getServer().func_195570_aG();
        manager.func_219534_a((IFutureReloadListener)FOOD_CATEGORY_MANAGER);
        manager.func_219534_a((IFutureReloadListener)RECIPE_MANAGER);
        manager.func_219534_a((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }

            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                if (ServerLifecycleHooks.getCurrentServer() != null) {
                    NetworkManager.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new PacketSyncCrockPotFoodCategory(FOOD_CATEGORY_MANAGER.serialize()));
                }
            }
        });
        manager.func_219534_a((IFutureReloadListener)new ReloadListener<Void>(){

            protected Void prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
                return null;
            }

            protected void apply(Void objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
                if (ModList.get().isLoaded("patchouli")) {
                    ModIntegrationPatchouli.addConfigFlag();
                }
            }
        });
        RecipeManager.initExecutor();
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)CrockPotRegistry.crockPotContainer.get()), CrockPotScreen::new);
    }

    public void onAnimalAppear(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof AnimalEntity) {
            AnimalEntity animalEntity = (AnimalEntity)event.getEntity();
            if (animalEntity instanceof SkeletonHorseEntity) {
                return;
            }
            if ((animalEntity.func_70661_as() instanceof GroundPathNavigator || animalEntity.func_70661_as() instanceof FlyingPathNavigator) && animalEntity.field_70714_bg.field_220892_d.stream().map(PrioritizedGoal::func_220772_j).noneMatch(e -> e instanceof TemptGoal && ((TemptGoal)e).func_188508_a(new ItemStack((IItemProvider)CrockPotRegistry.powCake.get())))) {
                animalEntity.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)animalEntity, 0.8, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CrockPotRegistry.powCake.get()})));
            }
        }
    }

    public void registerModifierSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new CrockPotSeedsDropModifier.Serializer().setRegistryName(new ResourceLocation(MOD_ID, "crockpot_seeds_drop")));
    }

    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().field_72995_K && event.getTarget() instanceof CowEntity) {
            CowEntity cow = (CowEntity)event.getTarget();
            PlayerEntity player = event.getPlayer();
            ItemStack stack = event.getItemStack();
            if (stack.func_77973_b() == Items.field_151069_bo && !cow.func_70631_g_()) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)CrockPotRegistry.milkBottle.get()))) {
                    player.func_71019_a(new ItemStack((IItemProvider)CrockPotRegistry.milkBottle.get()), false);
                }
            }
        }
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getEntity()), (Object)new PacketSyncCrockPotFoodCategory(FOOD_CATEGORY_MANAGER.serialize()));
        if (((Boolean)CrockPotConfig.SPAWN_WITH_BOOK.get()).booleanValue()) {
            CompoundNBT playerData = event.getPlayer().getPersistentData();
            CompoundNBT data = event.getPlayer().getPersistentData().func_74775_l("PlayerPersisted");
            if (!data.func_74767_n("crock_pot_book")) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)event.getPlayer(), (ItemStack)PatchouliAPI.instance.getBookStack(new ResourceLocation(MOD_ID, "book")));
                data.func_74757_a("crock_pot_book", true);
                playerData.func_218657_a("PlayerPersisted", (INBT)data);
            }
        }
    }

    public void addComposterRecipes(FMLLoadCompleteEvent event) {
        ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)CrockPotRegistry.asparagus.get()));
        ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)CrockPotRegistry.corn.get()));
        ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)CrockPotRegistry.onion.get()));
        ComposterBlock.func_220290_a((float)0.65f, (IItemProvider)((IItemProvider)CrockPotRegistry.tomato.get()));
        ComposterBlock.func_220290_a((float)0.85f, (IItemProvider)((IItemProvider)CrockPotRegistry.popcorn.get()));
    }
}

