/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot;

import com.sihenzhang.crockpot.base.CrockPotDamageSource;
import com.sihenzhang.crockpot.block.CornBlock;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.block.CrockPotCropsBlock;
import com.sihenzhang.crockpot.container.CrockPotContainer;
import com.sihenzhang.crockpot.item.CrockPotBlockItem;
import com.sihenzhang.crockpot.item.CrockPotCropsBlockItem;
import com.sihenzhang.crockpot.item.CrockPotFoodCategoryItem;
import com.sihenzhang.crockpot.item.food.Candy;
import com.sihenzhang.crockpot.item.food.CrockPotFood;
import com.sihenzhang.crockpot.item.food.FlowerSalad;
import com.sihenzhang.crockpot.item.food.FoodUseDuration;
import com.sihenzhang.crockpot.item.food.IceCream;
import com.sihenzhang.crockpot.tile.CrockPotTileEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class CrockPotRegistry {
    public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "crockpot");
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "crockpot");
    public static final DeferredRegister<TileEntityType<?>> TILES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "crockpot");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "crockpot");
    public static RegistryObject<Block> crockPotBasicBlock = BLOCKS.register("crock_pot_basic", () -> new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 0;
        }
    });
    public static RegistryObject<Item> crockPotBasicBlockItem = ITEMS.register("crock_pot_basic", () -> new CrockPotBlockItem((Block)crockPotBasicBlock.get()));
    public static RegistryObject<Block> crockPotAdvancedBlock = BLOCKS.register("crock_pot_advanced", () -> new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 1;
        }
    });
    public static RegistryObject<Item> crockPotAdvancedBlockItem = ITEMS.register("crock_pot_advanced", () -> new CrockPotBlockItem((Block)crockPotAdvancedBlock.get()));
    public static RegistryObject<Block> crockPotUltimateBlock = BLOCKS.register("crock_pot_ultimate", () -> new CrockPotBlock(){

        @Override
        public int getPotLevel() {
            return 2;
        }
    });
    public static RegistryObject<Item> crockPotUltimateBlockItem = ITEMS.register("crock_pot_ultimate", () -> new CrockPotBlockItem((Block)crockPotUltimateBlock.get()));
    public static RegistryObject<TileEntityType<CrockPotTileEntity>> crockPotTileEntity = TILES.register("crock_pot", () -> TileEntityType.Builder.func_223042_a(CrockPotTileEntity::new, (Block[])new Block[]{(Block)crockPotBasicBlock.get(), (Block)crockPotAdvancedBlock.get(), (Block)crockPotUltimateBlock.get()}).func_206865_a(null));
    public static RegistryObject<ContainerType<CrockPotContainer>> crockPotContainer = CONTAINERS.register("crock_pot", () -> IForgeContainerType.create((windowId, inv, data) -> {
        BlockPos pos = data.func_179259_c();
        TileEntity tileEntity = inv.field_70458_d.field_70170_p.func_175625_s(pos);
        return new CrockPotContainer(windowId, inv, (CrockPotTileEntity)Objects.requireNonNull(tileEntity));
    }));
    public static RegistryObject<Block> asparagusBlock = BLOCKS.register("asparaguses", () -> new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return (IItemProvider)asparagus.get();
        }
    });
    public static RegistryObject<Item> asparagus = ITEMS.register("asparagus", () -> new CrockPotCropsBlockItem((Block)asparagusBlock.get(), 3, 0.6f));
    public static RegistryObject<Block> cornBlock = BLOCKS.register("corns", CornBlock::new);
    public static RegistryObject<Item> cornSeeds = ITEMS.register("corn_seeds", () -> new CrockPotCropsBlockItem((Block)cornBlock.get()));
    public static RegistryObject<Item> corn = ITEMS.register("corn", () -> CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static RegistryObject<Item> popcorn = ITEMS.register("popcorn", () -> CrockPotFood.builder().hunger(3).saturation(0.6f).duration(FoodUseDuration.FAST).build());
    public static RegistryObject<Block> onionBlock = BLOCKS.register("onions", () -> new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return (IItemProvider)onion.get();
        }
    });
    public static RegistryObject<Item> onion = ITEMS.register("onion", () -> new CrockPotCropsBlockItem((Block)onionBlock.get(), 3, 0.6f));
    public static RegistryObject<Block> tomatoBlock = BLOCKS.register("tomatoes", () -> new CrockPotCropsBlock(){

        @Override
        @Nonnull
        protected IItemProvider func_199772_f() {
            return (IItemProvider)tomatoSeeds.get();
        }
    });
    public static RegistryObject<Item> tomatoSeeds = ITEMS.register("tomato_seeds", () -> new CrockPotCropsBlockItem((Block)tomatoBlock.get()));
    public static RegistryObject<Item> tomato = ITEMS.register("tomato", () -> CrockPotFood.builder().hunger(3).saturation(0.6f).build());
    public static RegistryObject<Item> milkBottle = ITEMS.register("milk_bottle", () -> CrockPotFood.builder().hunger(0).saturation(0.0f).setAlwaysEdible().setDrink().tooltip("milk_bottle").build());
    public static RegistryObject<Item> syrup = ITEMS.register("syrup", () -> CrockPotFood.builder().hunger(1).saturation(0.3f).setDrink().build());
    public static RegistryObject<Item> asparagusSoup = ITEMS.register("asparagus_soup", () -> CrockPotFood.builder().hunger(4).saturation(0.3f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().removePotion(Effects.field_76437_t).removePotion(Effects.field_76419_f).removePotion(Effects.field_76440_q).removePotion(Effects.field_76438_s).build());
    public static RegistryObject<Item> avaj = ITEMS.register("avaj", () -> CrockPotFood.builder().hunger(2).saturation(3.6f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 38800, 2).setHidden().rarity(Rarity.EPIC).build());
    public static RegistryObject<Item> baconEggs = ITEMS.register("bacon_eggs", () -> CrockPotFood.builder().hunger(12).saturation(0.8f).heal(4.0f).build());
    public static RegistryObject<Item> boneSoup = ITEMS.register("bone_soup", () -> CrockPotFood.builder().hunger(10).saturation(0.6f).effect(Effects.field_76444_x, 2400, 2).build());
    public static RegistryObject<Item> boneStew = ITEMS.register("bone_stew", () -> CrockPotFood.builder().hunger(20).saturation(0.3f).duration(FoodUseDuration.SUPER_SLOW).effect(Effects.field_76432_h, 1, 1).build());
    public static RegistryObject<Item> californiaRoll = ITEMS.register("california_roll", () -> CrockPotFood.builder().hunger(8).saturation(0.6f).effect(Effects.field_206827_D, 100).build());
    public static RegistryObject<Item> candy = ITEMS.register("candy", Candy::new);
    public static RegistryObject<Item> ceviche = ITEMS.register("ceviche", () -> CrockPotFood.builder().hunger(7).saturation(0.7f).setAlwaysEdible().effect(Effects.field_76424_c, 400, 2).effect(Effects.field_76429_m, 400, 1).effect(Effects.field_76444_x, 400, 2).build());
    public static RegistryObject<Item> fishSticks = ITEMS.register("fish_sticks", () -> CrockPotFood.builder().hunger(7).saturation(0.7f).effect(Effects.field_76428_l, 600, 1).build());
    public static RegistryObject<Item> fishTacos = ITEMS.register("fish_tacos", () -> CrockPotFood.builder().hunger(8).saturation(0.9f).build());
    public static RegistryObject<Item> flowerSalad = ITEMS.register("flower_salad", FlowerSalad::new);
    public static RegistryObject<Item> fruitMedley = ITEMS.register("fruit_medley", () -> CrockPotFood.builder().hunger(8).saturation(0.4f).effect(Effects.field_76424_c, 3600).build());
    public static RegistryObject<Item> gazpacho = ITEMS.register("gazpacho", () -> CrockPotFood.builder().hunger(6).saturation(0.4f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76426_n, 9600).build());
    public static RegistryObject<Item> honeyHam = ITEMS.register("honey_ham", () -> CrockPotFood.builder().hunger(12).saturation(0.8f).effect(Effects.field_76428_l, 400).effect(Effects.field_76444_x, 1200, 1).heal(6.0f).build());
    public static RegistryObject<Item> honeyNuggets = ITEMS.register("honey_nuggets", () -> CrockPotFood.builder().hunger(8).saturation(0.3f).effect(Effects.field_76428_l, 100).build());
    public static RegistryObject<Item> hotChili = ITEMS.register("hot_chili", () -> CrockPotFood.builder().hunger(9).saturation(0.8f).effect(Effects.field_76420_g, 1800).effect(Effects.field_76422_e, 1800).build());
    public static RegistryObject<Item> hotCocoa = ITEMS.register("hot_cocoa", () -> CrockPotFood.builder().hunger(2).saturation(0.1f).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 9600, 1).removePotion(Effects.field_76421_d).removePotion(Effects.field_76419_f).build());
    public static RegistryObject<Item> iceCream = ITEMS.register("ice_cream", IceCream::new);
    public static RegistryObject<Item> icedTea = ITEMS.register("iced_tea", () -> CrockPotFood.builder().hunger(3).saturation(0.1f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76430_j, 6000, 1).build());
    public static RegistryObject<Item> jammyPreserves = ITEMS.register("jammy_preserves", () -> CrockPotFood.builder().hunger(6).saturation(0.3f).duration(FoodUseDuration.FAST).build());
    public static RegistryObject<Item> kabobs = ITEMS.register("kabobs", () -> CrockPotFood.builder().hunger(7).saturation(0.7f).build());
    public static RegistryObject<Item> meatBalls = ITEMS.register("meat_balls", () -> CrockPotFood.builder().hunger(9).saturation(0.3f).build());
    public static RegistryObject<Item> monsterLasagna = ITEMS.register("monster_lasagna", () -> CrockPotFood.builder().hunger(7).saturation(0.2f).effect(Effects.field_76438_s, 300).effect(Effects.field_76436_u, 40).damage(CrockPotDamageSource.MONSTER_FOOD, 6.0f).build());
    public static RegistryObject<Item> monsterTartare = ITEMS.register("monster_tartare", () -> CrockPotFood.builder().hunger(8).saturation(0.7f).effect(Effects.field_76420_g, 1800, 1).build());
    public static RegistryObject<Item> moqueca = ITEMS.register("moqueca", () -> CrockPotFood.builder().hunger(14).saturation(0.7f).duration(FoodUseDuration.SLOW).effect(Effects.field_76428_l, 2400, 1).heal(6.0f).build());
    public static RegistryObject<Item> perogies = ITEMS.register("perogies", () -> CrockPotFood.builder().hunger(8).saturation(0.8f).heal(6.0f).build());
    public static RegistryObject<Item> potatoSouffle = ITEMS.register("potato_souffle", () -> CrockPotFood.builder().hunger(8).saturation(0.7f).effect(Effects.field_76429_m, 1800, 1).build());
    public static RegistryObject<Item> potatoTornado = ITEMS.register("potato_tornado", () -> CrockPotFood.builder().hunger(5).saturation(0.7f).duration(FoodUseDuration.FAST).removePotion(Effects.field_76438_s).build());
    public static RegistryObject<Item> powCake = ITEMS.register("pow_cake", () -> CrockPotFood.builder().hunger(2).saturation(0.1f).setAlwaysEdible().damage(CrockPotDamageSource.POW_CAKE, 1.0f).build());
    public static RegistryObject<Item> pumpkinCookie = ITEMS.register("pumpkin_cookie", () -> CrockPotFood.builder().hunger(8).saturation(0.6f).duration(FoodUseDuration.FAST).removePotion(Effects.field_76438_s).build());
    public static RegistryObject<Item> ratatouille = ITEMS.register("ratatouille", () -> CrockPotFood.builder().hunger(6).saturation(0.3f).duration(FoodUseDuration.FAST).build());
    public static RegistryObject<Item> salsa = ITEMS.register("salsa", () -> CrockPotFood.builder().hunger(7).saturation(0.8f).duration(FoodUseDuration.FAST).effect(Effects.field_76422_e, 7200).build());
    public static RegistryObject<Item> seafoodGumbo = ITEMS.register("seafood_gumbo", () -> CrockPotFood.builder().hunger(9).saturation(0.7f).duration(FoodUseDuration.FAST).effect(Effects.field_76428_l, 900, 1).build());
    public static RegistryObject<Item> surfNTurf = ITEMS.register("surf_n_turf", () -> CrockPotFood.builder().hunger(8).saturation(1.2f).setAlwaysEdible().effect(Effects.field_76444_x, 2400).heal(8.0f).build());
    public static RegistryObject<Item> taffy = ITEMS.register("taffy", () -> CrockPotFood.builder().hunger(5).saturation(0.4f).duration(FoodUseDuration.FAST).effect(Effects.field_188425_z, 2400).damage(CrockPotDamageSource.TAFFY, 1.0f).removePotion(Effects.field_76436_u).build());
    public static RegistryObject<Item> tea = ITEMS.register("tea", () -> CrockPotFood.builder().hunger(3).saturation(0.6f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76424_c, 12000, 1).effect(Effects.field_76422_e, 6000, 1).build());
    public static RegistryObject<Item> tropicalBouillabaisse = ITEMS.register("tropical_bouillabaisse", () -> CrockPotFood.builder().hunger(7).saturation(0.6f).duration(FoodUseDuration.FAST).setAlwaysEdible().effect(Effects.field_76424_c, 6000).effect(Effects.field_206827_D, 6000).effect(Effects.field_76427_o, 6000).cooldown(20).build());
    public static RegistryObject<Item> turkeyDinner = ITEMS.register("turkey_dinner", () -> CrockPotFood.builder().hunger(12).saturation(0.8f).effect(Effects.field_76429_m, 3600).build());
    public static RegistryObject<Item> vegStinger = ITEMS.register("veg_stinger", () -> CrockPotFood.builder().hunger(6).saturation(0.3f).duration(FoodUseDuration.FAST).setAlwaysEdible().setDrink().effect(Effects.field_76439_r, 7200).build());
    public static RegistryObject<Item> watermelonIcle = ITEMS.register("watermelon_icle", () -> CrockPotFood.builder().hunger(5).saturation(0.4f).duration(FoodUseDuration.FAST).effect(Effects.field_76424_c, 3600).effect(Effects.field_76430_j, 3600).removePotion(Effects.field_76421_d).build());
    public static RegistryObject<Item> wetGoop = ITEMS.register("wet_goop", () -> CrockPotFood.builder().hunger(0).saturation(0.0f).duration(FoodUseDuration.SUPER_SLOW).setAlwaysEdible().effect(Effects.field_76431_k, 200).tooltip("wet_goop", TextFormatting.ITALIC, TextFormatting.GRAY).build());
    public static RegistryObject<Item> foodCategoryMeat = ITEMS.register("food_category_meat", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryMonster = ITEMS.register("food_category_monster", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryFish = ITEMS.register("food_category_fish", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryEgg = ITEMS.register("food_category_egg", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryFruit = ITEMS.register("food_category_fruit", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryVeggie = ITEMS.register("food_category_veggie", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryDairy = ITEMS.register("food_category_dairy", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategorySweetener = ITEMS.register("food_category_sweetener", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryFrozen = ITEMS.register("food_category_frozen", CrockPotFoodCategoryItem::new);
    public static RegistryObject<Item> foodCategoryInedible = ITEMS.register("food_category_inedible", CrockPotFoodCategoryItem::new);
}

